/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.Stack;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpStructureUnit;
import lp.struct.LpVariable;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolpPrettyPrinter<W extends Writer>
extends LpPrettyPrinter<W> {
    protected boolean trackPosition;
    protected final Stack<MutableInteger> innerTermsLeft = new Stack();

    public static LpBuffer getBuffer() {
        return new LpBuffer(new EvolpPrettyPrinter<StringWriter>(new StringWriter()));
    }

    public static LpBuffer getBuffer(String arrow, boolean withSpaces) {
        return new LpBuffer(new EvolpPrettyPrinter<StringWriter>(new StringWriter(), arrow, withSpaces));
    }

    public EvolpPrettyPrinter(W out) {
        this(out, "<-", true);
    }

    public EvolpPrettyPrinter(W out, String arrow, boolean withSpaces) {
        super(out, arrow, withSpaces);
    }

    @Override
    public void write(LpStructureUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("The object to be written must not be null!");
        }
        this.trackPosition = unit instanceof LpRule || unit instanceof LpCompoundTerm || unit instanceof LpAtom;
        unit.accept(this);
        assert (this.innerTermsLeft.isEmpty());
    }

    protected void registerTerm() {
        if (this.trackPosition && !this.innerTermsLeft.empty()) {
            MutableInteger peek = this.innerTermsLeft.peek();
            peek.decrement();
            if (peek.getValue() == 0) {
                this.innerTermsLeft.pop();
            }
        }
    }

    @Override
    public void visit(LpConstant con) {
        super.visit(con);
        this.registerTerm();
    }

    @Override
    public void visit(LpVariable var) {
        super.visit(var);
        this.registerTerm();
    }

    @Override
    public void visit(LpFunction fun) {
        int arity;
        super.visit(fun);
        if (this.trackPosition && (arity = fun.getArity()) > 0) {
            this.innerTermsLeft.push(new MutableInteger(fun.getArity()));
        }
    }

    @Override
    public void visit(LpCompoundTerm term) {
        super.visit(term);
        this.registerTerm();
    }

    @Override
    public void visit(LpPredicate pred) {
        int arity;
        super.visit(pred);
        if (this.trackPosition && (arity = pred.getArity()) > 0) {
            this.innerTermsLeft.push(new MutableInteger(pred.getArity()));
        }
    }

    protected void appendOuterRule(LpRule rule) {
        this.appendRuleNoDot(rule);
        this.dot();
    }

    protected void appendInnerRule(LpRule rule) {
        boolean needParens;
        MutableInteger peek = this.innerTermsLeft.peek();
        Set<LpLiteral> body = rule.getBody();
        boolean bl = needParens = peek.getValue() > 1 && !body.isEmpty();
        if (needParens) {
            this.beginParen();
        }
        this.appendRuleNoDot(rule);
        if (body.isEmpty()) {
            this.space();
            this.arrow();
        }
        if (needParens) {
            this.endParen();
        }
    }

    @Override
    public void visit(LpRule rule) {
        if (this.innerTermsLeft.empty()) {
            this.appendOuterRule(rule);
        } else {
            this.appendInnerRule(rule);
            this.registerTerm();
        }
    }

    private static class MutableInteger {
        private int value;

        public MutableInteger(int initialValue) {
            this.value = initialValue;
        }

        public int getValue() {
            return this.value;
        }

        public void decrement() {
            --this.value;
        }
    }
}

