/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.io.StringWriter;
import lp.struct.LpStructureUnit;
import lp.struct.util.LpPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpBuffer
implements Appendable,
CharSequence {
    private final LpPrinter<StringWriter> printer;
    private final StringBuffer buffer;

    public LpBuffer(LpPrinter<StringWriter> printer) {
        this.printer = printer;
        this.buffer = printer.getOut().getBuffer();
    }

    @Override
    public LpBuffer append(CharSequence csq) {
        this.printer.append(csq);
        return this;
    }

    @Override
    public LpBuffer append(CharSequence csq, int start, int end) {
        this.printer.append(csq, start, end);
        return this;
    }

    @Override
    public LpBuffer append(char c) {
        this.printer.append(c);
        return this;
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.subSequence(start, end);
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    public LpBuffer append(LpStructureUnit unit) {
        this.printer.append(unit);
        return this;
    }

    public String asString(LpStructureUnit unit) {
        this.reset();
        this.append(unit);
        return this.toString();
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

