/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.LpVariable;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpEncoder<W extends Writer>
extends LpPrinter<W> {
    public static LpBuffer getBuffer() {
        return new LpBuffer(new LpEncoder<StringWriter>(new StringWriter()));
    }

    public LpEncoder(W out) {
        super(out);
    }

    protected void appendEncoded(CharSequence seq) {
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (this.escapeChar(c)) {
                this.write(95);
                this.write(Character.toLowerCase(c));
                continue;
            }
            this.write(c);
        }
    }

    protected boolean escapeChar(char c) {
        return c == '_' || c == 'L' || c == 'R' || c == 'C' || c == 'A' || c == 'D';
    }

    @Override
    public void visit(LpConstant con) {
        this.appendEncoded(con.getName());
    }

    @Override
    public void visit(LpVariable var) {
        this.appendEncoded(var.getName());
    }

    @Override
    public void visit(LpFunction fun) {
        this.appendEncoded(fun.getName());
    }

    protected void visitArgumentList(List<LpTerm> args) {
        if (args != null && !args.isEmpty()) {
            this.write(76);
            Iterator<LpTerm> i = args.iterator();
            i.next().accept(this);
            while (i.hasNext()) {
                this.write(67);
                i.next().accept(this);
            }
            this.write(82);
        }
    }

    @Override
    public void visit(LpCompoundTerm term) {
        this.visit(term.getFunction());
        this.visitArgumentList(term.getArguments());
    }

    @Override
    public void visit(LpPredicate pred) {
        this.appendEncoded(pred.getName());
    }

    @Override
    public void visit(LpAtom atom) {
        this.visit(atom.getPredicate());
        this.visitArgumentList(atom.getArguments());
    }

    @Override
    public void visit(LpLiteral lit) {
        if (!lit.isPositive()) {
            this.write("_N");
        }
        this.visit(lit.getAtom());
    }

    @Override
    public void visit(LpRule rule) {
        this.visit(rule.getHead());
        this.write(65);
        Set<LpLiteral> body = rule.getBody();
        if (!body.isEmpty()) {
            Iterator<LpLiteral> i = body.iterator();
            this.visit(i.next());
            while (i.hasNext()) {
                this.write(67);
                this.visit(i.next());
            }
        }
        this.write(68);
    }
}

