/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.util.List;
import java.util.Set;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpStructureUnit;
import lp.struct.LpStructureUnitVisitor;
import lp.struct.LpTerm;
import lp.struct.LpVariable;

public class LpGroundDecider
implements LpStructureUnitVisitor {
    private boolean ground = true;

    public boolean isGround(LpStructureUnit unit) {
        this.ground = true;
        unit.accept(this);
        return this.ground;
    }

    public void visit(LpConstant con) {
    }

    public void visit(LpVariable var) {
        this.ground = false;
    }

    public void visit(LpFunction fun) {
    }

    public void visit(LpCompoundTerm term) {
        for (LpTerm t : term.getArguments()) {
            t.accept(this);
            if (this.ground) continue;
            return;
        }
    }

    public void visit(LpPredicate pred) {
    }

    public void visit(LpAtom atom) {
        List<LpTerm> args = atom.getArguments();
        for (LpTerm t : args) {
            t.accept(this);
            if (this.ground) continue;
            return;
        }
    }

    public void visit(LpLiteral lit) {
        this.visit(lit.getAtom());
    }

    public void visit(LpRule rule) {
        LpLiteral head = rule.getHead();
        if (head != null) {
            this.visit(head);
        }
        if (!this.ground) {
            return;
        }
        Set<LpLiteral> body = rule.getBody();
        for (LpLiteral l : body) {
            this.visit(l);
            if (this.ground) continue;
            return;
        }
    }
}

