/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.io.StringWriter;
import java.io.Writer;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpVariable;
import lp.struct.util.EvolpPrettyPrinter;
import lp.struct.util.LpBuffer;
import lp.unit.DynamicLogicProgram;
import lp.unit.EvolpProgram;
import lp.unit.LogicProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpHtmlPrinter<W extends Writer>
extends EvolpPrettyPrinter<W> {
    public static LpBuffer getBuffer() {
        return new LpBuffer(new LpHtmlPrinter<StringWriter>(new StringWriter()));
    }

    public static LpBuffer getBuffer(String arrow, boolean withSpaces) {
        return new LpBuffer(new LpHtmlPrinter<StringWriter>(new StringWriter(), arrow, withSpaces));
    }

    public LpHtmlPrinter(W out) {
        this(out, "<-", true);
    }

    public LpHtmlPrinter(W out, String arrow, boolean withSpaces) {
        super(out, arrow, withSpaces);
    }

    public void append(DynamicLogicProgram dlp) {
        int i = 1;
        for (LogicProgram prog : dlp) {
            this.write("<div class=\"ruleGroup\">\n");
            this.write("<p class=\"comment\">% Program no. ");
            this.write(Integer.toString(i));
            this.write("</p>\n");
            for (LpRule r : prog) {
                this.write(r);
            }
            this.write("</div>\n\n");
            ++i;
        }
    }

    public void append(EvolpProgram evolp) {
        LogicProgram program = evolp.getBaseProgram();
        this.write("<div class=\"ruleGroup\">\n");
        this.write("<p class=\"comment\">% Base program</p>\n");
        for (LpRule r : program) {
            this.write(r);
        }
        this.write("</div>\n\n");
        int i = 1;
        for (LogicProgram event : evolp.getEvents()) {
            this.write("<div class=\"ruleGroup\">\n");
            this.write("<p class=\"comment\">% Event no. ");
            this.write(Integer.toString(i));
            this.write("</p>\n");
            for (LpRule r : event) {
                this.write(r);
            }
            this.write("</div>\n\n");
            ++i;
        }
    }

    protected void appendPunctuation(String punctuation) {
        this.write("<span class=\"punctuation\">");
        this.write(punctuation);
        this.write("</span>");
    }

    protected void appendPunctuation(char punctuation) {
        this.write("<span class=\"punctuation\">");
        this.write(punctuation);
        this.write("</span>");
    }

    @Override
    protected void beginParen() {
        this.appendPunctuation('(');
    }

    @Override
    protected void endParen() {
        this.appendPunctuation(')');
    }

    @Override
    protected void comma() {
        this.appendPunctuation(',');
    }

    @Override
    protected void literalPrefix(boolean positive) {
        if (!positive) {
            this.write("<span class=\"negLitPrefix\">not</span> ");
        }
    }

    @Override
    protected void arrow() {
        this.appendPunctuation(this.ARROW_STRING);
    }

    @Override
    protected void dot() {
        this.appendPunctuation('.');
    }

    @Override
    public void visit(LpConstant con) {
        this.write("<span class=\"constant\">");
        super.visit(con);
        this.write("</span>");
    }

    @Override
    public void visit(LpVariable var) {
        this.write("<span class=\"variable\">");
        super.visit(var);
        this.write("</span>");
    }

    @Override
    public void visit(LpFunction fun) {
        this.write("<span class=\"function\">");
        super.visit(fun);
        this.write("</span>");
    }

    @Override
    public void visit(LpPredicate pred) {
        this.write("<span class=\"predicate\">");
        super.visit(pred);
        this.write("</span>");
    }

    @Override
    protected void appendOuterRule(LpRule rule) {
        this.write("<p class=\"rule\">\n");
        super.appendOuterRule(rule);
        this.write("</p>\n");
    }
}

