/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.LpVariable;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LpPrettyPrinter<W extends Writer>
extends LpPrinter<W> {
    protected final String ARROW_STRING;
    protected final String SPACE_STRING;

    public static LpBuffer getBuffer() {
        return new LpBuffer(new LpPrettyPrinter<StringWriter>(new StringWriter()));
    }

    public static LpBuffer getBuffer(String arrow, boolean withSpaces) {
        return new LpBuffer(new LpPrettyPrinter<StringWriter>(new StringWriter(), arrow, withSpaces));
    }

    public LpPrettyPrinter(W out) {
        this(out, "<-", true);
    }

    public LpPrettyPrinter(W out, String arrow, boolean withSpaces) {
        super(out);
        if (arrow == null) {
            throw new IllegalArgumentException("The space and arrow strings must not be null!");
        }
        this.ARROW_STRING = arrow;
        this.SPACE_STRING = withSpaces ? " " : "";
    }

    protected void beginParen() {
        this.write(40);
    }

    protected void endParen() {
        this.write(41);
    }

    protected void comma() {
        this.write(44);
    }

    protected void space() {
        this.write(this.SPACE_STRING);
    }

    protected void literalPrefix(boolean positive) {
        if (!positive) {
            this.write("not ");
        }
    }

    protected void arrow() {
        this.write(this.ARROW_STRING);
    }

    protected void dot() {
        this.write(46);
    }

    @Override
    public void visit(LpConstant con) {
        this.write(con.getName());
    }

    @Override
    public void visit(LpVariable var) {
        this.write(var.getName());
    }

    @Override
    public void visit(LpFunction fun) {
        this.write(fun.getName());
    }

    protected void visitArgumentList(List<LpTerm> args) {
        if (args != null && !args.isEmpty()) {
            this.beginParen();
            Iterator<LpTerm> i = args.iterator();
            i.next().accept(this);
            while (i.hasNext()) {
                this.comma();
                this.space();
                i.next().accept(this);
            }
            this.endParen();
        }
    }

    @Override
    public void visit(LpCompoundTerm term) {
        this.visit(term.getFunction());
        this.visitArgumentList(term.getArguments());
    }

    @Override
    public void visit(LpPredicate pred) {
        this.write(pred.getName());
    }

    @Override
    public void visit(LpAtom atom) {
        this.visit(atom.getPredicate());
        this.visitArgumentList(atom.getArguments());
    }

    @Override
    public void visit(LpLiteral lit) {
        this.literalPrefix(lit.isPositive());
        this.visit(lit.getAtom());
    }

    protected void appendRuleNoDot(LpRule rule) {
        LpLiteral head = rule.getHead();
        Set<LpLiteral> body = rule.getBody();
        if (head != null) {
            this.visit(head);
        }
        if (!body.isEmpty()) {
            if (head != null) {
                this.space();
            }
            this.arrow();
            this.space();
            Iterator<LpLiteral> i = body.iterator();
            this.visit(i.next());
            while (i.hasNext()) {
                this.comma();
                this.space();
                this.visit(i.next());
            }
        }
    }

    @Override
    public void visit(LpRule rule) {
        this.appendRuleNoDot(rule);
        this.dot();
    }
}

