/*
 * Decompiled with CFR 0.152.
 */
package lp.struct.util;

import java.io.IOException;
import java.io.Writer;
import lp.struct.LpStructureUnit;
import lp.struct.LpStructureUnitVisitor;
import lp.util.ExceptionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LpPrinter<W extends Writer>
extends Writer
implements LpStructureUnitVisitor {
    private W out;

    protected LpPrinter(W out) {
        this.out = out;
    }

    public W getOut() {
        return this.out;
    }

    public void setOut(W out) {
        this.out = out;
    }

    public LpPrinter append(LpStructureUnit unit) {
        if (unit == null) {
            this.append("null");
        } else {
            this.write(unit);
        }
        return this;
    }

    public void write(LpStructureUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("The object to be written must not be null!");
        }
        unit.accept(this);
    }

    @Override
    public void write(int c) {
        try {
            ((Writer)this.getOut()).write(c);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    @Override
    public void write(char[] cbuf) {
        try {
            ((Writer)this.getOut()).write(cbuf);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        try {
            ((Writer)this.getOut()).write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    @Override
    public void write(String str) {
        try {
            ((Writer)this.getOut()).write(str);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    @Override
    public void write(String str, int off, int len) {
        try {
            ((Writer)this.getOut()).write(str, off, len);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    @Override
    public LpPrinter append(CharSequence csq) {
        try {
            ((Writer)this.getOut()).append(csq);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
        return this;
    }

    @Override
    public LpPrinter append(CharSequence csq, int start, int end) {
        try {
            ((Writer)this.getOut()).append(csq, start, end);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
        return this;
    }

    @Override
    public LpPrinter append(char c) {
        try {
            ((Writer)this.getOut()).append(c);
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
        return this;
    }

    @Override
    public void flush() {
        try {
            ((Writer)this.getOut()).flush();
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    @Override
    public void close() {
        try {
            ((Writer)this.getOut()).close();
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }
}

