/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lp.parse.LpParser;
import lp.parse.LpTokenType;
import lp.struct.LpAtom;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.util.LpPrettyPrinter;
import lp.trans.Grounder;
import lp.trans.GrounderMessage;
import lp.unit.DynamicLogicProgram;
import lp.unit.GeneralizedLogicProgram;
import lp.unit.LogicProgram;
import lp.wrap.LparseMessage;
import lp.wrap.LparseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DlpGrounder
extends Grounder<DynamicLogicProgram> {
    private int programCount;
    private final DlpTagger<Writer> printer = new DlpTagger<Object>(null);
    private final DlpDetagger parser = new DlpDetagger();

    public DlpGrounder() {
        this(new LparseWrapper());
    }

    public DlpGrounder(LparseWrapper wrapper) {
        super(wrapper);
    }

    @Override
    protected void printProgram(DynamicLogicProgram inputProgram, Writer writer) {
        this.programCount = inputProgram.size();
        this.printer.reset();
        this.printer.setOut(writer);
        Iterator iter = inputProgram.iterator();
        if (iter.hasNext()) {
            for (LpRule r : (LogicProgram)iter.next()) {
                this.printer.append(r);
                this.printer.append('\n');
            }
            while (iter.hasNext()) {
                this.printer.incTagNumber();
                for (LpRule r : (LogicProgram)iter.next()) {
                    this.printer.append(r);
                    this.printer.append('\n');
                }
            }
        }
        this.printer.appendTagFacts();
        this.printer.close();
    }

    @Override
    protected GrounderMessage makeGrounderMessage(LparseMessage message, DynamicLogicProgram inputProgram) {
        LpRule rule = null;
        int pIndex = 0;
        if (inputProgram.size() > 0) {
            int rIndex;
            int pCount = inputProgram.size();
            int pRuleCount = ((LogicProgram)inputProgram.get(0)).size();
            for (rIndex = message.getLineNumber() - 1; pIndex < pCount && rIndex >= pRuleCount; rIndex -= pRuleCount) {
                pRuleCount = ((LogicProgram)inputProgram.get(++pIndex)).size();
            }
            if (pIndex < pCount) {
                rule = ((LogicProgram)inputProgram.get(pIndex)).get(rIndex);
            }
        }
        return new GrounderMessage(message.getMessage(), rule, message.isWarning(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DynamicLogicProgram parseOutput(String program) {
        DynamicLogicProgram result = new DynamicLogicProgram(this.programCount);
        for (int i = 0; i < this.programCount; ++i) {
            result.add(new GeneralizedLogicProgram());
        }
        this.parser.setInput(program);
        try {
            while (this.parser.hasMoreTokens()) {
                LpRule r = this.parser.parseRule();
                if (r == null) continue;
                ((LogicProgram)result.get(this.parser.getTagNumber())).add(r);
            }
        }
        finally {
            this.parser.close();
        }
        return result;
    }

    private static class DlpDetagger
    extends LpParser {
        private static final LpLiteral TAG = LpAtom.getInstance(LpPredicate.getInstance("tag", 0), null).getPositiveLiteral();
        private int tagNumber = 0;

        public void setInput(CharSequence input) {
            super.setInput(input);
            this.tagNumber = 0;
        }

        public int getTagNumber() {
            return this.tagNumber;
        }

        public LpRule parseRule() {
            LpLiteral head = this.getLexer().getTokenType() == LpTokenType.RULE_ARROW ? null : this.parseLiteral();
            while (this.hasMoreTokens() && head == TAG) {
                this.match(LpTokenType.DOT);
                if (!this.hasMoreTokens()) continue;
                head = this.parseLiteral();
            }
            if (!this.hasMoreTokens()) {
                return null;
            }
            LinkedHashSet<LpLiteral> body = null;
            if (this.getLexer().getTokenType() == LpTokenType.RULE_ARROW) {
                this.nextToken();
                if (this.getLexer().getTokenType() == LpTokenType.LOWERCASE_WORD) {
                    body = new LinkedHashSet<LpLiteral>();
                    LpLiteral l = this.parseLiteral();
                    if (l != TAG) {
                        body.add(l);
                    }
                    while (this.getLexer().getTokenType() == LpTokenType.COMMA) {
                        this.nextToken();
                        l = this.parseLiteral();
                        if (l == TAG) continue;
                        body.add(l);
                    }
                }
            }
            this.match(LpTokenType.DOT);
            return new LpRule(head, body);
        }

        public LpLiteral parseLiteral() {
            boolean positive = true;
            if (this.getLexer().getTokenType() == LpTokenType.LOWERCASE_WORD && this.getLexer().getLexem().equals("not")) {
                positive = false;
                this.nextToken();
            }
            this.expect(LpTokenType.LOWERCASE_WORD);
            String name = this.getLexer().getLexem();
            this.nextToken();
            if (name.startsWith("p_")) {
                name = name.substring(2);
            } else if (name.startsWith("n_")) {
                name = name.substring(2);
                positive = false;
            } else {
                if (name.matches("tag[0-9]+")) {
                    this.tagNumber = Integer.decode(name.substring(3));
                    return TAG;
                }
                if ("_false".equals(name)) {
                    return null;
                }
                throw new IllegalArgumentException("Bad input program!");
            }
            List<LpTerm> arguments = this.parseArguments();
            LpPredicate pred = LpPredicate.getInstance(name, arguments);
            LpAtom atom = LpAtom.getInstance(pred, arguments);
            return atom.getLiteral(positive);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DlpTagger<W extends Writer>
    extends LpPrettyPrinter<W> {
        private int tagNumber;
        private boolean visitingHead;

        public DlpTagger(W out) {
            super(out, ":-", false);
            this.reset();
        }

        public void reset() {
            this.tagNumber = 0;
        }

        public void incTagNumber() {
            ++this.tagNumber;
        }

        @Override
        public void visit(LpRule rule) {
            LpLiteral head = rule.getHead();
            Set<LpLiteral> body = rule.getBody();
            if (head != null) {
                this.visitingHead = true;
                this.visit(head);
                this.append(this.SPACE_STRING);
            }
            this.append(this.ARROW_STRING);
            this.append(this.SPACE_STRING);
            for (LpLiteral l : body) {
                this.visit(l);
                this.append(',');
                this.append(this.SPACE_STRING);
            }
            this.append("tag").append(Integer.toString(this.tagNumber));
            this.append('.');
        }

        @Override
        public void visit(LpLiteral lit) {
            if (this.visitingHead) {
                this.append(lit.isPositive() ? "p_" : "n_");
                this.visitingHead = false;
            } else {
                if (!lit.isPositive()) {
                    this.append("not ");
                }
                this.append("p_");
            }
            this.visit(lit.getAtom());
        }

        public void appendTagFacts() {
            for (int i = 0; i <= this.tagNumber; ++i) {
                this.append("tag").append(Integer.toString(i)).append(".\n");
            }
        }
    }
}

