/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lp.struct.LpAtom;
import lp.struct.LpConstant;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpEncoder;
import lp.trans.IntArrayWrapper;
import lp.unit.DynamicLogicProgram;
import lp.unit.LogicProgram;
import lp.unit.TransDlpRuleType;
import lp.unit.TransformedDlp;

public class DlpTransformer {
    private final Map<LpAtom, AtomInfo> atomData = new HashMap<LpAtom, AtomInfo>();
    private final LpBuffer encoder = LpEncoder.getBuffer();
    private int progCount;

    private AtomInfo getData(LpAtom atom) {
        AtomInfo result = this.atomData.get(atom);
        if (result == null) {
            result = new AtomInfo(atom);
            this.atomData.put(atom, result);
        }
        return result;
    }

    public TransformedDlp transform(DynamicLogicProgram dlp) {
        AtomInfo data;
        LpLiteral head;
        int level;
        LogicProgram prog;
        int i;
        if (!dlp.isGround()) {
            throw new IllegalArgumentException("DlpTransformer only accepts grounded dynamic logic programs!");
        }
        this.progCount = dlp.size();
        TransformedDlp result = new TransformedDlp();
        for (i = 0; i < dlp.size(); ++i) {
            prog = (LogicProgram)dlp.get(i);
            level = i + 1;
            for (LpRule r : prog) {
                result.add(this.makeTransformedRule(r, level), TransDlpRuleType.REWRITTEN_RULE);
                head = r.getHead();
                if (head != null) {
                    data = this.getData(head.getAtom());
                    data.addOccurence(head.isPositive(), level);
                }
                for (LpLiteral l : r.getBody()) {
                    if (l.isPositive()) continue;
                    this.getData(l.getAtom()).setDefaultNeeded();
                }
            }
        }
        for (i = 0; i < dlp.size(); ++i) {
            prog = (LogicProgram)dlp.get(i);
            level = i + 1;
            for (LpRule r : prog) {
                int introToLevel;
                head = r.getHead();
                if (head == null || (introToLevel = (data = this.getData(head.getAtom())).getMaxLeqThan(!head.isPositive(), level)) <= -1) continue;
                result.add(this.makeIntroRejection(r, introToLevel), TransDlpRuleType.INTRO_REJECTION);
            }
        }
        for (AtomInfo app : this.atomData.values()) {
            app.addRulesTo(result);
        }
        this.atomData.clear();
        return result;
    }

    private LpRule makeTransformedRule(LpRule origRule, int level) {
        LpLiteral origHead = origRule.getHead();
        LpLiteral head = this.makeTransformedLiteral(origHead, true);
        LinkedHashSet<LpLiteral> body = new LinkedHashSet<LpLiteral>();
        for (LpLiteral l : origRule.getBody()) {
            body.add(this.makeTransformedLiteral(l, true));
        }
        body.add(this.makeRejectionAtom(origHead, level).getNegativeLiteral());
        return new LpRule(head, body);
    }

    private LpRule makeIntroRejection(LpRule origRule, int toLevel) {
        LpLiteral origHead = origRule.getHead();
        LpLiteral head = this.makeRejectionAtom(origHead.getAtom().getLiteral(!origHead.isPositive()), toLevel).getPositiveLiteral();
        LinkedHashSet<LpLiteral> body = new LinkedHashSet<LpLiteral>();
        for (LpLiteral l : origRule.getBody()) {
            body.add(this.makeTransformedLiteral(l, true));
        }
        return new LpRule(head, body);
    }

    private LpLiteral makeTransformedLiteral(LpLiteral origLit, boolean positive) {
        if (origLit == null) {
            return null;
        }
        LpPredicate origPred = origLit.getPredicate();
        StringBuilder predName = new StringBuilder();
        predName.append(origLit.isPositive() ? "" : "_N");
        predName.append(origLit.getPredicate().getName());
        LpPredicate pred = LpPredicate.getInstance(predName.toString(), origPred.getArity());
        return LpAtom.getInstance(pred, origLit.getArguments()).getLiteral(positive);
    }

    private LpAtom makeRejectionAtom(LpLiteral lit, int level) {
        LpConstant litConst = LpConstant.getInstance(this.encoder.asString(lit));
        LpPredicate rejPred = LpPredicate.getInstance("_rej", 2);
        ArrayList<LpTerm> args = new ArrayList<LpTerm>(2);
        args.add(LpConstant.getInstance(Integer.toString(level)));
        args.add(litConst);
        return LpAtom.getInstance(rejPred, args);
    }

    private class AtomInfo {
        private final LpAtom forAtom;
        private boolean defaultNeeded;
        private final IntArrayWrapper posOccurences;
        private final IntArrayWrapper negOccurences;

        public AtomInfo(LpAtom forAtom) {
            this.forAtom = forAtom;
            this.defaultNeeded = false;
            this.posOccurences = new IntArrayWrapper(DlpTransformer.this.progCount);
            this.negOccurences = new IntArrayWrapper(DlpTransformer.this.progCount);
        }

        public void setDefaultNeeded() {
            this.defaultNeeded = true;
        }

        public int getMaxLeqThan(boolean positive, int level) {
            if (positive) {
                return this.posOccurences.getMaxLeqThan(level);
            }
            int result = this.negOccurences.getMaxLeqThan(level);
            if (result == -1 && this.defaultNeeded) {
                result = 0;
            }
            return result;
        }

        public void addOccurence(boolean positive, int level) {
            if (positive) {
                this.posOccurences.add(level);
            } else {
                this.negOccurences.add(level);
            }
        }

        public void addRulesTo(TransformedDlp prog) {
            boolean makeDefault;
            boolean makeConstraint = false;
            for (int level = 1; level <= DlpTransformer.this.progCount; ++level) {
                if (!this.posOccurences.contains(level) || !this.negOccurences.contains(level)) continue;
                makeConstraint = true;
            }
            boolean bl = makeDefault = this.defaultNeeded || makeConstraint;
            if (makeDefault) {
                prog.add(this.makeDefault(), TransDlpRuleType.DEFAULT_RULE);
            }
            if (makeConstraint) {
                prog.add(this.makeConstraint(), TransDlpRuleType.CONSTRAINT);
            }
            int maxNeg = this.negOccurences.getMax();
            if (!this.posOccurences.isEmpty()) {
                int fromLevel;
                int toLevel = this.posOccurences.get(0);
                for (int i = 1; i < this.posOccurences.length() && (fromLevel = this.posOccurences.get(i)) <= maxNeg; ++i) {
                    prog.add(this.makePropagationRejection(true, fromLevel, toLevel), TransDlpRuleType.PROPAGATION_REJECTION);
                    toLevel = fromLevel;
                }
            }
            int maxPos = this.posOccurences.getMax();
            if (!this.negOccurences.isEmpty()) {
                int fromLevel;
                int i;
                int toLevel;
                if (makeDefault) {
                    toLevel = 0;
                    i = 0;
                } else {
                    toLevel = this.negOccurences.get(0);
                    i = 1;
                }
                while (i < this.negOccurences.length() && (fromLevel = this.negOccurences.get(i)) <= maxPos) {
                    prog.add(this.makePropagationRejection(false, fromLevel, toLevel), TransDlpRuleType.PROPAGATION_REJECTION);
                    toLevel = fromLevel;
                    ++i;
                }
            }
        }

        private LpRule makePropagationRejection(boolean positive, int fromLevel, int toLevel) {
            LpLiteral origHead = this.forAtom.getLiteral(positive);
            LpLiteral head = DlpTransformer.this.makeRejectionAtom(origHead, toLevel).getPositiveLiteral();
            Set<LpLiteral> body = Collections.singleton(DlpTransformer.this.makeRejectionAtom(origHead, fromLevel).getPositiveLiteral());
            return new LpRule(head, body);
        }

        private LpRule makeDefault() {
            LpLiteral origLit = this.forAtom.getNegativeLiteral();
            LpLiteral head = DlpTransformer.this.makeTransformedLiteral(origLit, true);
            Set<LpLiteral> body = Collections.singleton(DlpTransformer.this.makeRejectionAtom(origLit, 0).getNegativeLiteral());
            return new LpRule(head, body);
        }

        private LpRule makeConstraint() {
            LinkedHashSet<LpLiteral> body = new LinkedHashSet<LpLiteral>(2);
            body.add(DlpTransformer.this.makeTransformedLiteral(this.forAtom.getPositiveLiteral(), false));
            body.add(DlpTransformer.this.makeTransformedLiteral(this.forAtom.getNegativeLiteral(), false));
            return new LpRule(null, body);
        }
    }
}

