/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import lp.parse.EvolpParser;
import lp.parse.LpTokenType;
import lp.struct.LpAtom;
import lp.struct.LpPredicate;
import lp.struct.LpTerm;
import lp.trans.Solver;
import lp.unit.EvolutionStableModel;
import lp.unit.StableModel;
import lp.util.ExceptionAdapter;
import lp.wrap.LparseWrapper;
import lp.wrap.SmodelsWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolpSolver
extends Solver<EvolutionStableModel> {
    private final TransEvolpParser parser = new TransEvolpParser();
    private int modelLength;

    public EvolpSolver() {
        this(new LparseWrapper(), new SmodelsWrapper());
    }

    public EvolpSolver(LparseWrapper lparseWrapper, SmodelsWrapper smodelsWrapper) {
        super(lparseWrapper, smodelsWrapper);
    }

    public void setModelLength(int modelLength) {
        this.modelLength = modelLength;
    }

    @Override
    protected EvolutionStableModel parseModel(String modelString) {
        EvolutionStableModel result = new EvolutionStableModel();
        for (int i = 0; i < this.modelLength; ++i) {
            result.add(new StableModel());
        }
        this.parser.setInput(modelString);
        while (this.parser.hasMoreTokens()) {
            LpAtom a = this.parser.parseAtom();
            if (a == null) continue;
            int group = this.parser.getGroup();
            ((StableModel)result.get(group - 1)).add(a);
        }
        this.parser.close();
        return result;
    }

    private static class Decoder
    extends Reader {
        private final Reader in;
        private final char[] buffer;
        private int top;

        public Decoder(Reader in) {
            this.in = in;
            this.buffer = new char[3];
            this.top = -1;
        }

        public int read() throws IOException {
            int c;
            if (this.top > -1) {
                c = this.buffer[this.top];
                --this.top;
            } else {
                c = this.in.read();
                switch (c) {
                    case 95: {
                        c = this.in.read();
                        if (c == 78) {
                            c = 110;
                            this.buffer[2] = 111;
                            this.buffer[1] = 116;
                            this.buffer[0] = 32;
                            this.top = 2;
                            break;
                        }
                        c = Character.toUpperCase(c);
                        break;
                    }
                    case 76: {
                        c = 40;
                        break;
                    }
                    case 82: {
                        c = 41;
                        break;
                    }
                    case 67: {
                        c = 44;
                        break;
                    }
                    case 65: {
                        this.buffer[0] = 45;
                        this.top = 0;
                        c = 60;
                        break;
                    }
                    case 68: {
                        c = 46;
                    }
                }
            }
            System.out.print((char)c);
            return c;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int pos;
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            int maxPos = off + len - 1;
            for (pos = off; c != -1 && pos <= maxPos; ++pos) {
                cbuf[pos] = (char)c;
                c = this.read();
            }
            return pos - off;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private class TransEvolpParser
    extends EvolpParser {
        private int group;
        private boolean topLevel = true;

        private TransEvolpParser() {
        }

        public void setInput(CharSequence input) {
            if (input == null) {
                throw new IllegalArgumentException("The source string cannot be null!");
            }
            this.setInput(new StringReader(((Object)input).toString()));
        }

        public void setInput(File file) {
            if (file == null) {
                throw new IllegalArgumentException("The source file cannot be null!");
            }
            try {
                this.setInput(new BufferedReader(new FileReader(file)));
            }
            catch (IOException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public void setInput(Reader input) {
            super.setInput(new Decoder(input));
        }

        public LpAtom parseAtom() {
            if (this.topLevel) {
                this.expect(LpTokenType.LOWERCASE_WORD);
                String name = this.getLexer().getLexem();
                int posN = name.lastIndexOf(78);
                this.group = Integer.parseInt(name.substring(posN + 1));
                name = name.substring(0, name.lastIndexOf(78));
                this.topLevel = false;
                this.nextToken();
                List<LpTerm> arguments = this.parseArguments();
                this.topLevel = true;
                LpPredicate pred = LpPredicate.getInstance(name, arguments);
                return LpAtom.getInstance(pred, arguments);
            }
            return super.parseAtom();
        }

        public int getGroup() {
            return this.group;
        }
    }
}

