/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpEncoder;
import lp.trans.IntArrayWrapper;
import lp.unit.EvolpProgram;
import lp.unit.GeneralizedLogicProgram;
import lp.unit.LogicProgram;
import lp.unit.TransEvolpRuleType;
import lp.unit.TransformedEvolp;

public class EvolpTransformer {
    private final List<LogicProgram> programs = new ArrayList<LogicProgram>();
    private List<LogicProgram> events = new ArrayList<LogicProgram>();
    private final TransformationHelper helper = new TransformationHelper();
    private final Map<LpAtom, AtomAppearance> appearances = new HashMap<LpAtom, AtomAppearance>();
    private int eventCount = 0;

    private AtomAppearance getData(LpAtom atom) {
        AtomAppearance result = this.appearances.get(atom);
        if (result == null) {
            result = new AtomAppearance(atom);
            this.appearances.put(atom, result);
        }
        return result;
    }

    public TransformedEvolp transform(EvolpProgram evolp) {
        int i;
        if (!evolp.isGround()) {
            throw new IllegalArgumentException("Only grounded evolving logic programs are accepted!");
        }
        this.programs.clear();
        this.programs.add(evolp.getBaseProgram());
        this.events = evolp.getEvents();
        this.eventCount = this.events.size();
        for (int i2 = 1; i2 < this.eventCount; ++i2) {
            this.programs.add(new GeneralizedLogicProgram());
        }
        for (LpRule r : this.programs.get(0)) {
            this.extractAssertions(r, 1, false);
        }
        for (i = 0; i < this.eventCount; ++i) {
            for (LpRule r : this.events.get(i)) {
                this.extractAssertions(r, i + 1, true);
            }
        }
        for (i = 0; i < this.eventCount; ++i) {
            for (LpRule r : this.programs.get(i)) {
                this.extractAppearance(r, i + 1, false);
            }
            for (LpRule r : this.events.get(i)) {
                this.extractAppearance(r, i + 1, true);
            }
        }
        TransformedEvolp result = new TransformedEvolp();
        for (int group = 1; group <= this.eventCount; ++group) {
            for (LpRule r : this.programs.get(0)) {
                result.add(this.helper.transform(r, group, false, 1), group, TransEvolpRuleType.REWRITTEN_PROGRAM_RULE);
                this.outputRejection(result, r, group, 1, false);
            }
            for (LpRule r : this.events.get(group - 1)) {
                result.add(this.helper.transform(r, group, false, group), group, TransEvolpRuleType.REWRITTEN_EVENT_RULE);
                this.outputRejection(result, r, group, group, false);
            }
            for (int level = 2; level <= group; ++level) {
                for (LpRule r : this.programs.get(level - 1)) {
                    result.add(this.helper.transform(r, group, true, level), group, TransEvolpRuleType.ASSERTABLE_RULE);
                    this.outputRejection(result, r, group, level, true);
                }
            }
        }
        for (AtomAppearance appear : this.appearances.values()) {
            appear.addRulesTo(result);
        }
        this.appearances.clear();
        return result;
    }

    private void extractAssertions(LpRule startRule, int startLevel, boolean eventRule) {
        LpRule rule = startRule;
        boolean event = eventRule;
        int level = startLevel;
        boolean cont = true;
        while (level < this.eventCount && cont) {
            LpLiteral headLiteral = rule.getHead();
            LpAtom headAtom = headLiteral.getAtom();
            LpPredicate headPredicate = headAtom.getPredicate();
            cont = headLiteral.isPositive() && headPredicate.getArity() == 1 && "assert".equals(headPredicate.getName());
            if (!cont) continue;
            rule = (LpRule)headAtom.getArguments().get(0);
            if (event) {
                this.programs.get(level).add(rule);
                event = false;
            } else {
                for (int i = level; i < this.eventCount; ++i) {
                    this.programs.get(i).add(rule);
                }
            }
            ++level;
        }
    }

    private void extractAppearance(LpRule r, int level, boolean eventRule) {
        for (LpLiteral l : r.getBody()) {
            if (l.isPositive()) continue;
            this.getData(l.getAtom()).addNegativeBodyAppearance(level, eventRule);
        }
        LpLiteral l = r.getHead();
        this.getData(l.getAtom()).addHeadAppearance(level, eventRule, l.isPositive());
    }

    private void outputRejection(TransformedEvolp result, LpRule r, int group, int level, boolean assertion) {
        LpLiteral head = r.getHead();
        int oppositeLevel = this.appearances.get(head.getAtom()).nextOppositeLevel(group, level, head.isPositive());
        if (oppositeLevel > -1) {
            result.add(this.helper.makeIntroRejection(r, group, level, oppositeLevel, assertion), group, TransEvolpRuleType.INTRO_REJECTION);
        }
    }

    private class AtomAppearance {
        private final LpAtom forAtom;
        private final IntArrayWrapper posProgRuleHead;
        private final IntArrayWrapper negProgRuleHead;
        private final IntArrayWrapper posEventRuleHead;
        private final IntArrayWrapper negEventRuleHead;
        private int defFromGroup;
        private final IntArrayWrapper defInGroup;

        public AtomAppearance(LpAtom forAtom) {
            this.forAtom = forAtom;
            this.defFromGroup = EvolpTransformer.this.eventCount + 1;
            this.defInGroup = new IntArrayWrapper(EvolpTransformer.this.eventCount);
            this.posProgRuleHead = new IntArrayWrapper(EvolpTransformer.this.eventCount);
            this.negProgRuleHead = new IntArrayWrapper(EvolpTransformer.this.eventCount);
            this.posEventRuleHead = new IntArrayWrapper(EvolpTransformer.this.eventCount);
            this.negEventRuleHead = new IntArrayWrapper(EvolpTransformer.this.eventCount);
        }

        public void addNegativeBodyAppearance(int level, boolean eventRule) {
            if (eventRule) {
                this.defInGroup.add(level);
            } else if (this.defFromGroup > level) {
                this.defFromGroup = level;
            }
        }

        public void addHeadAppearance(int level, boolean eventRule, boolean isPositive) {
            IntArrayWrapper target = eventRule ? (isPositive ? this.posEventRuleHead : this.negEventRuleHead) : (isPositive ? this.posProgRuleHead : this.negProgRuleHead);
            target.add(level);
        }

        public int nextOppositeLevel(int group, int level, boolean positive) {
            if (positive) {
                if (group == level && this.negEventRuleHead.contains(level)) {
                    return level;
                }
                int max = this.negProgRuleHead.getMaxLeqThan(level);
                if (max == -1 && this.hasDefaultInGroup(group)) {
                    return 0;
                }
                return max;
            }
            if (group == level && this.posEventRuleHead.contains(level)) {
                return level;
            }
            return this.posProgRuleHead.getMaxLeqThan(level);
        }

        public void addRulesTo(TransformedEvolp prog) {
            this.outputDefaults(prog);
            this.outputRejections(prog);
            this.outputConstraints(prog);
        }

        private boolean hasConstraintInGroup(int group) {
            boolean result = false;
            for (int i = 1; i < group; ++i) {
                if (!this.posProgRuleHead.contains(i) || !this.negProgRuleHead.contains(i)) continue;
                result = true;
                break;
            }
            if ((this.posProgRuleHead.contains(group) || this.posEventRuleHead.contains(group)) && (this.negProgRuleHead.contains(group) || this.negEventRuleHead.contains(group))) {
                result = true;
            }
            return result;
        }

        private boolean hasDefaultInGroup(int group) {
            if (group >= this.defFromGroup) {
                return true;
            }
            return this.defInGroup.contains(group) || this.hasConstraintInGroup(group);
        }

        private void outputDefaults(TransformedEvolp prog) {
            for (int group = 1; group <= EvolpTransformer.this.eventCount; ++group) {
                if (!this.hasDefaultInGroup(group) && !this.hasConstraintInGroup(group)) continue;
                prog.add(EvolpTransformer.this.helper.makeDefaultAssumption(this.forAtom, group), group, TransEvolpRuleType.DEFAULT_RULE);
            }
        }

        private void outputConstraints(TransformedEvolp prog) {
            for (int group = 1; group <= EvolpTransformer.this.eventCount; ++group) {
                if (!this.hasConstraintInGroup(group)) continue;
                prog.add(EvolpTransformer.this.helper.makeTotalityConstraint(this.forAtom, group), group, TransEvolpRuleType.CONSTRAINT);
            }
        }

        private void outputRejections(TransformedEvolp prog) {
            for (int group = 1; group <= EvolpTransformer.this.eventCount; ++group) {
                LpRule rule;
                int fromLevel;
                int toLevel;
                boolean posEvent = this.posEventRuleHead.contains(group);
                boolean negEvent = this.negEventRuleHead.contains(group);
                boolean hasDefault = this.hasDefaultInGroup(group);
                int maxPos = posEvent ? group : this.posProgRuleHead.getMaxLeqThan(group);
                int maxNeg = negEvent ? group : this.negProgRuleHead.getMaxLeqThan(group);
                int i = 0;
                if (!this.posProgRuleHead.isEmpty()) {
                    toLevel = this.posProgRuleHead.get(0);
                    ++i;
                    while (i < this.posProgRuleHead.length() && (fromLevel = this.posProgRuleHead.get(i)) <= maxNeg) {
                        rule = EvolpTransformer.this.helper.makePropagationRejection(this.forAtom.getPositiveLiteral(), group, fromLevel, toLevel);
                        prog.add(rule, group, TransEvolpRuleType.PROPAGATION_REJECTION);
                        toLevel = fromLevel;
                        ++i;
                    }
                    if (posEvent && toLevel < group) {
                        rule = EvolpTransformer.this.helper.makePropagationRejection(this.forAtom.getPositiveLiteral(), group, group, toLevel);
                        prog.add(rule, group, TransEvolpRuleType.PROPAGATION_REJECTION);
                    }
                }
                if (!this.negProgRuleHead.isEmpty()) {
                    if (hasDefault) {
                        toLevel = 0;
                        i = 0;
                    } else {
                        toLevel = this.negProgRuleHead.get(0);
                        i = 1;
                    }
                    while (i < this.negProgRuleHead.length() && (fromLevel = this.negProgRuleHead.get(i)) <= maxPos) {
                        rule = EvolpTransformer.this.helper.makePropagationRejection(this.forAtom.getNegativeLiteral(), group, fromLevel, toLevel);
                        prog.add(rule, group, TransEvolpRuleType.PROPAGATION_REJECTION);
                        toLevel = fromLevel;
                        ++i;
                    }
                    if (!negEvent || toLevel >= group) continue;
                    rule = EvolpTransformer.this.helper.makePropagationRejection(this.forAtom.getNegativeLiteral(), group, group, toLevel);
                    prog.add(rule, group, TransEvolpRuleType.PROPAGATION_REJECTION);
                    continue;
                }
                if (!negEvent || !hasDefault) continue;
                LpRule rule2 = EvolpTransformer.this.helper.makePropagationRejection(this.forAtom.getNegativeLiteral(), group, group, 0);
                prog.add(rule2, group, TransEvolpRuleType.PROPAGATION_REJECTION);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformationHelper {
        private final LpBuffer encoder = LpEncoder.getBuffer();

        public LpRule transform(LpRule rule, int group, boolean assertion, int level) {
            LpLiteral head = rule.getHead();
            LpLiteral newHead = this.transform(rule.getHead(), group, true);
            Set<LpLiteral> body = rule.getBody();
            int bodySize = assertion ? body.size() + 2 : body.size() + 1;
            LinkedHashSet<LpLiteral> newBody = new LinkedHashSet<LpLiteral>(bodySize);
            for (LpLiteral lit : body) {
                newBody.add(this.transform(lit, group, true));
            }
            if (assertion) {
                newBody.add(this.makeAssertionLiteral(rule, level));
            }
            newBody.add(this.makeRejectionAtom(head, group, level).getNegativeLiteral());
            return new LpRule(newHead, newBody);
        }

        private LpLiteral transform(LpLiteral lit, int group, boolean positive) {
            if (lit == null) {
                return null;
            }
            LpPredicate pred = lit.getPredicate();
            this.encoder.reset();
            this.encoder.append(lit.isPositive() ? "" : "_N");
            this.encoder.append(pred);
            this.encoder.append('N').append(Integer.toString(group));
            LpPredicate newPred = LpPredicate.getInstance(this.encoder.toString(), pred.getArity());
            List<LpTerm> newArgs = this.transform(lit.getArguments());
            return LpAtom.getInstance(newPred, newArgs).getLiteral(positive);
        }

        private LpLiteral transformPlain(LpLiteral lit, int group) {
            if (lit == null) {
                return null;
            }
            LpPredicate pred = lit.getPredicate();
            this.encoder.reset();
            this.encoder.append(pred.getName());
            this.encoder.append('N').append(Integer.toString(group));
            LpPredicate newPred = LpPredicate.getInstance(this.encoder.toString(), pred.getArity());
            List<LpTerm> newArgs = this.transform(lit.getArguments());
            return LpAtom.getInstance(newPred, newArgs).getLiteral(lit.isPositive());
        }

        private List<LpTerm> transform(List<LpTerm> args) {
            ArrayList<LpTerm> newArgs = new ArrayList<LpTerm>(args.size());
            for (LpTerm term : args) {
                newArgs.add(this.transform(term));
            }
            return newArgs;
        }

        private LpTerm transform(LpTerm term) {
            if (term instanceof LpConstant) {
                return LpConstant.getInstance(this.encoder.asString(term));
            }
            if (term instanceof LpRule) {
                return LpConstant.getInstance(this.encoder.asString(term));
            }
            LpCompoundTerm compound = (LpCompoundTerm)term;
            LpFunction newFun = LpFunction.getInstance(this.encoder.asString(compound.getFunction()), compound.getArguments());
            List<LpTerm> newArgs = this.transform(compound.getArguments());
            return LpCompoundTerm.getInstance(newFun, newArgs);
        }

        private LpLiteral makeAssertionLiteral(LpRule rule, int level) {
            LpPredicate prevAssert = LpPredicate.getInstance("assertN" + Integer.toString(level - 1), 1);
            LpConstant ruleConst = LpConstant.getInstance(this.encoder.asString(rule));
            LpAtom assAtom = LpAtom.getInstance(prevAssert, Collections.singletonList(ruleConst));
            return assAtom.getPositiveLiteral();
        }

        private LpAtom makeRejectionAtom(LpLiteral lit, int group, int level) {
            LpLiteral transLit = this.transformPlain(lit, group);
            LpConstant litConst = LpConstant.getInstance(this.encoder.asString(transLit));
            LpPredicate rejPred = LpPredicate.getInstance("_rej", 2);
            ArrayList<LpTerm> args = new ArrayList<LpTerm>(2);
            args.add(LpConstant.getInstance(Integer.toString(level)));
            args.add(litConst);
            return LpAtom.getInstance(rejPred, args);
        }

        private LpRule makeIntroRejection(LpRule rule, int group, int fromLevel, int toLevel, boolean assertion) {
            LpLiteral head = rule.getHead();
            LpLiteral newHead = this.makeRejectionAtom(head.getAtom().getLiteral(!head.isPositive()), group, toLevel).getPositiveLiteral();
            LinkedHashSet<LpLiteral> newBody = new LinkedHashSet<LpLiteral>();
            for (LpLiteral lit : rule.getBody()) {
                newBody.add(this.transform(lit, group, true));
            }
            if (assertion) {
                newBody.add(this.makeAssertionLiteral(rule, fromLevel));
            }
            return new LpRule(newHead, newBody);
        }

        private LpRule makePropagationRejection(LpLiteral lit, int group, int fromLevel, int toLevel) {
            LpLiteral head = this.makeRejectionAtom(lit, group, toLevel).getPositiveLiteral();
            Set<LpLiteral> body = Collections.singleton(this.makeRejectionAtom(lit, group, fromLevel).getPositiveLiteral());
            return new LpRule(head, body);
        }

        private LpRule makeDefaultAssumption(LpAtom atom, int group) {
            LpLiteral origLit = atom.getNegativeLiteral();
            LpLiteral head = this.transform(origLit, group, true);
            Set<LpLiteral> body = Collections.singleton(this.makeRejectionAtom(origLit, group, 0).getNegativeLiteral());
            return new LpRule(head, body);
        }

        private LpRule makeTotalityConstraint(LpAtom atom, int group) {
            LinkedHashSet<LpLiteral> body = new LinkedHashSet<LpLiteral>(2);
            body.add(this.transform(atom.getPositiveLiteral(), group, false));
            body.add(this.transform(atom.getNegativeLiteral(), group, false));
            return new LpRule(null, body);
        }
    }
}

