/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lp.struct.LpAtom;
import lp.struct.LpCompoundTerm;
import lp.struct.LpConstant;
import lp.struct.LpFunction;
import lp.struct.LpLiteral;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpTerm;
import lp.struct.LpVariable;
import lp.struct.util.LpBuffer;
import lp.struct.util.LpEncoder;
import lp.trans.DlpGrounder;
import lp.unit.DynamicLogicProgram;
import lp.unit.EvolpProgram;
import lp.unit.GeneralizedLogicProgram;
import lp.unit.LogicProgram;

public class EvolpVarTransformer {
    private final List<LogicProgram> programs = new ArrayList<LogicProgram>();
    private List<LogicProgram> events = new ArrayList<LogicProgram>();
    private int eventCount = 0;
    private final DlpGrounder grounder = new DlpGrounder();
    private final TransformationHelper helper = new TransformationHelper();

    public void setLparsePath(String lparsePath) {
        this.grounder.setLparsePath(lparsePath);
    }

    public DynamicLogicProgram transform(EvolpProgram evolp) {
        int group;
        this.programs.clear();
        this.programs.add(evolp.getBaseProgram());
        this.events = evolp.getEvents();
        this.eventCount = this.events.size();
        DynamicLogicProgram dlp = new DynamicLogicProgram();
        for (group = 1; group <= this.eventCount; ++group) {
            dlp.add(new GeneralizedLogicProgram());
        }
        this.helper.reset();
        for (group = 1; group <= this.eventCount; ++group) {
            for (int level = 0; level < group; ++level) {
                LogicProgram current = (LogicProgram)dlp.get(level);
                for (LpRule r : this.programs.get(level)) {
                    current.add(this.helper.transform(r, group, level));
                }
            }
            LogicProgram current = (LogicProgram)dlp.get(group - 1);
            for (LpRule r : this.events.get(group - 1)) {
                current.add(this.helper.transform(r, group, 0));
            }
            if (!dlp.isGround()) {
                dlp = this.grounder.ground(dlp);
            }
            GeneralizedLogicProgram newProg = new GeneralizedLogicProgram();
            String assertName = "assertN" + group;
            for (int level = 0; level < group; ++level) {
                for (LpRule r : (LogicProgram)dlp.get(level)) {
                    LpPredicate headPred = r.getHead().getPredicate();
                    if (!assertName.equals(headPred.getName()) || headPred.getArity() != 1) continue;
                    newProg.add(this.helper.decode((LpConstant)r.getHead().getArguments().get(0)));
                }
            }
            this.programs.add(newProg);
        }
        return dlp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformationHelper {
        private final LpBuffer encoder = LpEncoder.getBuffer();
        private final HashMap<LpConstant, LpRule> decoder = new HashMap();

        public void reset() {
            this.decoder.clear();
        }

        public LpRule decode(LpConstant encoded) {
            return this.decoder.get(encoded);
        }

        public LpRule transform(LpRule rule, int group, int assertLevel) {
            LpLiteral newHead = this.transform(rule.getHead(), group);
            Set<LpLiteral> body = rule.getBody();
            boolean assertion = assertLevel > 0;
            int bodySize = assertion ? body.size() + 1 : body.size();
            LinkedHashSet<LpLiteral> newBody = new LinkedHashSet<LpLiteral>(bodySize);
            for (LpLiteral lit : body) {
                newBody.add(this.transform(lit, group));
            }
            if (assertion) {
                LpPredicate prevAssert = LpPredicate.getInstance("assertN" + Integer.toString(assertLevel), 1);
                LpConstant ruleConst = LpConstant.getInstance(this.encoder.asString(rule));
                LpAtom assAtom = LpAtom.getInstance(prevAssert, Collections.singletonList(ruleConst));
                LpLiteral assGuard = assAtom.getPositiveLiteral();
                newBody.add(assGuard);
            }
            return new LpRule(newHead, newBody);
        }

        private LpLiteral transform(LpLiteral lit, int group) {
            if (lit == null) {
                return null;
            }
            LpPredicate pred = lit.getPredicate();
            this.encoder.reset();
            this.encoder.append(pred);
            this.encoder.append('N').append(Integer.toString(group));
            LpPredicate newPred = LpPredicate.getInstance(this.encoder.toString(), pred.getArity());
            List<LpTerm> newArgs = this.transform(lit.getArguments());
            return LpAtom.getInstance(newPred, newArgs).getLiteral(lit.isPositive());
        }

        private List<LpTerm> transform(List<LpTerm> args) {
            ArrayList<LpTerm> newArgs = new ArrayList<LpTerm>(args.size());
            for (LpTerm term : args) {
                newArgs.add(this.transform(term));
            }
            return newArgs;
        }

        private LpTerm transform(LpTerm term) {
            if (term instanceof LpVariable) {
                return term;
            }
            if (term instanceof LpConstant) {
                return LpConstant.getInstance(this.encoder.asString(term));
            }
            if (term instanceof LpRule) {
                LpConstant ruleConst = LpConstant.getInstance(this.encoder.asString(term));
                this.decoder.put(ruleConst, (LpRule)term);
                return ruleConst;
            }
            LpCompoundTerm compound = (LpCompoundTerm)term;
            LpFunction newFun = LpFunction.getInstance(this.encoder.asString(compound.getFunction()), compound.getArguments());
            List<LpTerm> newArgs = this.transform(compound.getArguments());
            return LpCompoundTerm.getInstance(newFun, newArgs);
        }
    }
}

