/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import lp.trans.GrounderMessage;
import lp.wrap.LparseMessage;
import lp.wrap.LparseWrapper;
import lp.wrap.WrapperUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Grounder<P> {
    private final LparseWrapper lw;
    private final List<GrounderMessage> warnings;

    public Grounder(LparseWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("The lparse wrapper object must not be null!");
        }
        this.lw = wrapper;
        this.warnings = new ArrayList<GrounderMessage>();
    }

    public void setLparsePath(String lparsePath) {
        this.lw.setLparsePath(lparsePath);
    }

    public P ground(P inputProgram) {
        if (inputProgram == null) {
            return null;
        }
        this.lw.setOptions("-t -d all");
        this.lw.exec();
        this.printProgram(inputProgram, new OutputStreamWriter(this.lw.getStdin()));
        String stdout = WrapperUtils.getInstance().dumpToString(this.lw.getStdout());
        String program = stdout.substring(0, Math.max(0, stdout.lastIndexOf(10, Math.max(0, stdout.length() - 2))));
        this.lw.waitFor();
        if (this.lw.getError() != null) {
            throw this.makeGrounderMessage(this.lw.getError(), inputProgram);
        }
        this.warnings.clear();
        for (LparseMessage w : this.lw.getWarnings()) {
            this.warnings.add(this.makeGrounderMessage(w, inputProgram));
        }
        return this.parseOutput(program);
    }

    public List<GrounderMessage> getWarnings() {
        return this.warnings;
    }

    protected abstract void printProgram(P var1, Writer var2);

    protected abstract GrounderMessage makeGrounderMessage(LparseMessage var1, P var2);

    protected abstract P parseOutput(String var1);
}

