/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

class IntArrayWrapper {
    private final int[] members;
    private int top;

    public IntArrayWrapper(int maxCount) {
        this.members = new int[maxCount];
        this.top = -1;
    }

    public void add(int newMember) {
        if (this.top == -1 || newMember > this.members[this.top]) {
            this.members[++this.top] = newMember;
        }
    }

    public int length() {
        return this.top + 1;
    }

    public int getTop() {
        return this.top;
    }

    public int get(int i) {
        return this.members[i];
    }

    public int getMax() {
        return this.top == -1 ? -1 : this.members[this.top];
    }

    public int getMaxLeqThan(int limit) {
        if (this.top == -1 || this.members[0] > limit) {
            return -1;
        }
        if (this.members[this.top] <= limit) {
            return this.members[this.top];
        }
        int i = this.top - 1;
        while (this.members[i] > limit) {
            --i;
        }
        return this.members[i];
    }

    public boolean contains(int number) {
        int i;
        if (this.top == -1) {
            return false;
        }
        for (i = 0; i < this.top && this.members[i] < number; ++i) {
        }
        return this.members[i] == number;
    }

    public boolean isEmpty() {
        return this.top == -1;
    }
}

