/*
 * Decompiled with CFR 0.152.
 */
package lp.trans;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import lp.struct.LpRule;
import lp.struct.util.LpPrettyPrinter;
import lp.struct.util.LpPrinter;
import lp.trans.Consumer;
import lp.unit.LogicProgram;
import lp.util.ExceptionAdapter;
import lp.wrap.LparseWrapper;
import lp.wrap.SmodelsWrapper;
import lp.wrap.WrapperUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Solver<M> {
    private final LparseWrapper lw;
    private final SmodelsWrapper sw;
    private final LpPrinter<Writer> printer;
    private int modelCount;

    public Solver(LparseWrapper lparseWrapper, SmodelsWrapper smodelsWrapper) {
        if (lparseWrapper == null) {
            throw new IllegalArgumentException("The lparse wrapper object must not be null!");
        }
        if (smodelsWrapper == null) {
            throw new IllegalArgumentException("The smodels wrapper object must not be null!");
        }
        this.lw = lparseWrapper;
        this.sw = smodelsWrapper;
        this.printer = new LpPrettyPrinter<Object>(null, ":-", false);
    }

    public void setLparsePath(String lparsePath) {
        this.lw.setLparsePath(lparsePath);
    }

    public void setSmodelsPath(String smodelsPath) {
        this.sw.setSmodelsPath(smodelsPath);
    }

    public void setModelLimit(int modelLimit) {
        this.sw.setModelLimit(modelLimit);
    }

    public void solve(LogicProgram program, Consumer<M> consumer) {
        if (!program.isGround()) {
            throw new IllegalArgumentException("The program must be groundedbefore its models are computed!");
        }
        this.lw.exec();
        this.printer.setOut(new OutputStreamWriter(this.lw.getStdin()));
        for (LpRule r : program) {
            this.printer.append(r);
            this.printer.append('\n');
        }
        this.printer.close();
        InputStream lparseOutput = this.lw.getStdout();
        this.sw.exec();
        WrapperUtils.getInstance().transfer(lparseOutput, this.sw.getStdin());
        this.sw.closeStdin();
        BufferedReader smodelsOutput = new BufferedReader(new InputStreamReader(this.sw.getStdout()));
        this.modelCount = 0;
        try {
            String modelString = Solver.getNextModelString(smodelsOutput);
            while (modelString != null) {
                ++this.modelCount;
                consumer.consume(this.parseModel(modelString));
                modelString = Solver.getNextModelString(smodelsOutput);
            }
            smodelsOutput.close();
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
        this.lw.waitFor();
        this.sw.waitFor();
    }

    public int getModelCount() {
        return this.modelCount;
    }

    protected static String getNextModelString(BufferedReader smodelsOutput) throws IOException {
        String INTRO = "Stable Model: ";
        String line = "";
        while (line != null && !line.startsWith(INTRO)) {
            line = smodelsOutput.readLine();
        }
        if (line != null) {
            line = line.substring(INTRO.length());
            return line;
        }
        return null;
    }

    protected abstract M parseModel(String var1);
}

