/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import lp.ui.ConfigManager;

public abstract class AbstractProcessor {
    private final StopWatch sw;
    private final ConfigManager config;

    public AbstractProcessor(ConfigManager config) {
        this.config = config;
        this.sw = new StopWatch();
    }

    protected ConfigManager getConfig() {
        return this.config;
    }

    protected StopWatch getSW() {
        return this.sw;
    }

    protected abstract void showMessage(String var1);

    protected void chmod(String key) {
        try {
            Process p = Runtime.getRuntime().exec("/bin/chmod +x " + this.getConfig().getProperty(key));
            p.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String escapeXMLSpecials(String input) {
        StringBuilder sb = new StringBuilder();
        int length = input.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    protected class StopWatch {
        private String before;
        private String after;
        private long time;

        public StopWatch() {
            this.before = this.before;
            this.after = this.after;
        }

        public void setMessages(String before, String after) {
            this.before = before;
            this.after = after;
        }

        public void start() {
            AbstractProcessor.this.showMessage(this.before);
            this.time = System.currentTimeMillis();
        }

        public void stop() {
            long duration = System.currentTimeMillis() - this.time;
            int sec = (int)(duration / 1000L);
            int millis = (int)(duration % 1000L);
            String millisFormated = millis < 10 ? "00" + millis : (millis < 100 ? "0" + millis : Integer.toString(millis));
            AbstractProcessor.this.showMessage(this.after + " " + sec + "." + millisFormated + "s");
        }
    }
}

