/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager
extends Properties {
    private static final char SEP;
    public static final String CONFIG_NAME;
    public static final File USER_CONFIG;
    public static final File CURRENT_DIR_CONFIG;

    public ConfigManager() {
        String suffix = SEP == '/' ? "" : ".exe";
        this.defaults = new Properties();
        this.defaults.setProperty("location.dlv", "dlv" + suffix);
        this.defaults.setProperty("location.lparse", "lparse" + suffix);
        this.defaults.setProperty("location.smodels", "smodels" + suffix);
        this.defaults.setProperty("aspsolver", "smodels");
        this.defaults.setProperty("quiet", "false");
        this.defaults.setProperty("maxModels", "0");
    }

    public void loadConfig(File configFile) throws IOException {
        this.loadFromXML(new FileInputStream(configFile));
    }

    public void loadConfig(String configFilename) throws IOException {
        this.loadConfig(new File(configFilename));
    }

    public void loadUserConfig() throws IOException {
        if (USER_CONFIG.exists() && USER_CONFIG.canRead()) {
            this.loadConfig(USER_CONFIG);
        }
    }

    public void loadCurrentDirConfig() throws IOException {
        if (CURRENT_DIR_CONFIG.exists() && CURRENT_DIR_CONFIG.canRead()) {
            this.loadConfig(CURRENT_DIR_CONFIG);
        }
    }

    public void saveConfig(File configFile) throws IOException {
        Properties toStore = new Properties();
        for (String name : this.sortedPropertyNames()) {
            toStore.setProperty(name, this.getProperty(name));
        }
        toStore.storeToXML(new FileOutputStream(configFile), "This file contains settings for the implementation of transformational semantics for Evolving Logic Programs; see http://slotik.medovnicek.sk/thesis/ for details");
    }

    public void saveConfig(String configFilename) throws IOException {
        this.saveConfig(new File(configFilename));
    }

    public SortedSet<String> sortedPropertyNames() {
        TreeSet<String> result = new TreeSet<String>();
        Enumeration<?> names = this.propertyNames();
        while (names.hasMoreElements()) {
            result.add((String)names.nextElement());
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.sortedPropertyNames()) {
            sb.append(key + ": \"" + this.getProperty(key) + "\"\n");
        }
        return sb.toString();
    }

    static {
        File current;
        File user;
        SEP = File.separatorChar;
        CONFIG_NAME = SEP == '/' ? ".evolp.properties" : "_evolp.properties";
        try {
            user = new File(System.getProperty("user.home") + SEP + CONFIG_NAME);
            current = new File(System.getProperty("user.home") + SEP + CONFIG_NAME);
        }
        catch (Exception e) {
            user = null;
            current = null;
        }
        USER_CONFIG = user;
        CURRENT_DIR_CONFIG = current;
    }
}

