/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import java.io.Reader;
import java.util.List;
import lp.parse.DlpParser;
import lp.trans.Consumer;
import lp.trans.DlpGrounder;
import lp.trans.DlpSolver;
import lp.trans.DlpTransformer;
import lp.trans.GrounderMessage;
import lp.ui.AbstractProcessor;
import lp.ui.ConfigManager;
import lp.unit.DynamicLogicProgram;
import lp.unit.StableModel;
import lp.unit.TransformedDlp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DlpProcessor
extends AbstractProcessor {
    private final DlpParser parser = new DlpParser();
    private final DlpGrounder grounder = new DlpGrounder();
    private final DlpTransformer transformer = new DlpTransformer();
    private final DlpSolver solver = new DlpSolver();
    private Reader input = null;
    private DynamicLogicProgram dlp = null;
    private DynamicLogicProgram groundedDlp = null;
    private TransformedDlp transformedDlp = null;

    public DlpProcessor(ConfigManager config) {
        super(config);
    }

    public void setInput(Reader input) {
        this.input = input;
        this.dlp = null;
        this.groundedDlp = null;
        this.transformedDlp = null;
    }

    public DynamicLogicProgram getDlp() {
        if (this.dlp == null) {
            this.getSW().setMessages("Reading input...", "Input parsed in");
            this.getSW().start();
            this.parser.setInput(this.input);
            this.dlp = this.parser.parseDlp();
            this.getSW().stop();
        }
        return this.dlp;
    }

    public DynamicLogicProgram getGroundedDlp() {
        if (this.groundedDlp == null) {
            DynamicLogicProgram tmp = this.getDlp();
            this.getSW().setMessages("Grounding the DLP...", "Grounding took");
            this.getSW().start();
            this.grounder.setLparsePath(this.getConfig().getProperty("location.lparse"));
            this.groundedDlp = this.grounder.ground(tmp);
            this.getSW().stop();
        }
        return this.groundedDlp;
    }

    public List<GrounderMessage> getGrounderWarnings() {
        return this.grounder.getWarnings();
    }

    public TransformedDlp getTransformedDlp() {
        if (this.transformedDlp == null) {
            DynamicLogicProgram tmp = this.getGroundedDlp();
            this.getSW().setMessages("Transforming input...", "Transformation lasted");
            this.getSW().start();
            this.transformedDlp = this.transformer.transform(tmp);
            this.getSW().stop();
        }
        return this.transformedDlp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeModels(Consumer<StableModel> processor) {
        int maxModels;
        try {
            maxModels = Integer.parseInt(this.getConfig().getProperty("maxModels"));
        }
        catch (NumberFormatException e) {
            maxModels = 0;
        }
        this.solver.setLparsePath(this.getConfig().getProperty("location.lparse"));
        this.solver.setSmodelsPath(this.getConfig().getProperty("location.smodels"));
        this.solver.setModelLimit(maxModels);
        TransformedDlp tmp = this.getTransformedDlp();
        this.getSW().setMessages("Calling Smodels...", "Dynamic stable models computed in");
        this.getSW().start();
        processor.beforeConsuming();
        try {
            this.solver.solve(tmp, processor);
        }
        finally {
            processor.afterConsuming();
        }
        int n = this.solver.getModelCount();
        switch (n) {
            case 0: {
                this.showMessage("No dynamic stable model exists");
                break;
            }
            case 1: {
                this.showMessage("1 dynamic stable model computed");
                break;
            }
            default: {
                this.showMessage(n + " dynamic stable models computed");
            }
        }
        this.getSW().stop();
    }
}

