/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpStructureUnit;
import lp.struct.util.LpHtmlPrinter;
import lp.trans.Consumer;
import lp.ui.ConfigManager;
import lp.ui.DlpProcessor;
import lp.ui.JspPrinter;
import lp.unit.DynamicLogicProgram;
import lp.unit.StableModel;
import lp.unit.TransDlpRuleType;
import lp.unit.TransformedDlp;

public class DlpWebappHelper
extends DlpProcessor {
    private final JspPrinter printer;
    private final TransDlpHtmlPrinter<Writer> transPrinter;
    private final DlpModelProcessor processor;
    private boolean error;

    public DlpWebappHelper(ConfigManager config, JspWriter out) {
        super(config);
        this.printer = new JspPrinter(out);
        this.transPrinter = new TransDlpHtmlPrinter(this, (Writer)out);
        this.processor = new DlpModelProcessor();
        this.error = false;
    }

    public void setInput(Reader input) {
        super.setInput(input);
        this.error = false;
    }

    protected void showMessage(String message) {
        this.printer.showMessage(message);
    }

    public boolean isError() {
        return this.error;
    }

    protected void showError(String comment, Exception e) {
        this.printer.showError(comment, e);
        this.error = true;
    }

    public void writeDlp() {
        if (!this.error) {
            try {
                DynamicLogicProgram tmp = this.getDlp();
                if (!this.error) {
                    this.printer.append("<div class=\"code\">\n");
                    this.printer.append(tmp);
                    this.printer.append("</div>\n\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't parse input program!", e);
            }
        }
    }

    public void writeGroundedDlp() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                DynamicLogicProgram tmp = this.getGroundedDlp();
                if (!this.error) {
                    this.printer.append("<div class=\"code\">\n");
                    this.printer.append(tmp);
                    this.printer.append("</div>\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't ground the input program!", e);
            }
        }
    }

    public void writeTransformedDlp() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                TransformedDlp tmp = this.getTransformedDlp();
                if (!this.error) {
                    this.transPrinter.append("<div class=\"code\">\n");
                    this.transPrinter.append(tmp);
                    this.transPrinter.append("</div>\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't transform the input program!", e);
            }
        }
    }

    public void writeModels() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                this.chmod("location.smodels");
                this.computeModels(this.processor);
            }
            catch (Exception e) {
                this.showError("Couldn't compute the stable models!", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DlpModelProcessor
    implements Consumer<StableModel> {
        private int n = 0;

        @Override
        public void beforeConsuming() {
            this.n = 0;
            DlpWebappHelper.this.printer.println("<div class=\"code\">");
        }

        @Override
        public void afterConsuming() {
            DlpWebappHelper.this.printer.println("</div>\n");
        }

        @Override
        public void consume(StableModel model) {
            ++this.n;
            DlpWebappHelper.this.printer.append("<p class=\"model\">M<sub>" + this.n + "</sub> = {");
            Iterator i = model.iterator();
            if (i.hasNext()) {
                DlpWebappHelper.this.printer.append((LpStructureUnit)i.next());
            }
            while (i.hasNext()) {
                DlpWebappHelper.this.printer.append(", ");
                DlpWebappHelper.this.printer.append((LpStructureUnit)i.next());
            }
            DlpWebappHelper.this.printer.append("}</p>\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransDlpHtmlPrinter<W extends Writer>
    extends LpHtmlPrinter<W> {
        final /* synthetic */ DlpWebappHelper this$0;

        public TransDlpHtmlPrinter(W out) {
            this.this$0 = var1_1;
            super(out, ":-", true);
        }

        public void append(TransformedDlp transDlp) {
            for (TransDlpRuleType t : TransDlpRuleType.values()) {
                this.append("<div class=\"ruleGroup\">\n");
                this.append("<p class=\"comment\">% " + (Object)((Object)t));
                this.append("</p>\n");
                for (LpRule r : transDlp.getGroup(t)) {
                    this.append(r);
                }
                this.append("</div>\n\n");
            }
        }

        @Override
        public void visit(LpPredicate pred) {
            String name = pred.getName();
            if (name.startsWith("_N")) {
                this.append("<span class=\"negLitPrefix\">_N</span>");
                name = name.substring(2);
            }
            this.append("<span class=\"predicate\">");
            this.append(name);
            this.append("</span>");
        }
    }
}

