/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import java.io.Reader;
import lp.parse.EvolpParser;
import lp.trans.Consumer;
import lp.trans.EvolpSolver;
import lp.trans.EvolpTransformer;
import lp.ui.AbstractProcessor;
import lp.ui.ConfigManager;
import lp.unit.EvolpProgram;
import lp.unit.EvolutionStableModel;
import lp.unit.TransformedEvolp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvolpProcessor
extends AbstractProcessor {
    private final EvolpParser parser = new EvolpParser();
    private final EvolpTransformer transformer = new EvolpTransformer();
    private final EvolpSolver solver = new EvolpSolver();
    private Reader input = null;
    private EvolpProgram evolp = null;
    private TransformedEvolp transformedEvolp = null;

    public EvolpProcessor(ConfigManager config) {
        super(config);
    }

    public void setInput(Reader input) {
        this.input = input;
        this.evolp = null;
        this.transformedEvolp = null;
    }

    protected EvolpProgram getEvolp() {
        if (this.evolp == null) {
            this.transformedEvolp = null;
            this.getSW().setMessages("Reading input...", "Input parsed in");
            this.getSW().start();
            this.parser.setInput(this.input);
            this.evolp = this.parser.parseEvolp();
            this.getSW().stop();
        }
        return this.evolp;
    }

    protected TransformedEvolp getTransformedEvolp() {
        if (this.transformedEvolp == null) {
            EvolpProgram tmp = this.getEvolp();
            this.getSW().setMessages("Transforming input...", "Transformation lasted");
            this.getSW().start();
            this.transformedEvolp = this.transformer.transform(tmp);
            this.getSW().stop();
        }
        return this.transformedEvolp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeModels(Consumer<EvolutionStableModel> processor) {
        int maxModels;
        try {
            maxModels = Integer.parseInt(this.getConfig().getProperty("maxModels"));
        }
        catch (NumberFormatException e) {
            maxModels = 0;
        }
        this.solver.setLparsePath(this.getConfig().getProperty("location.lparse"));
        this.solver.setSmodelsPath(this.getConfig().getProperty("location.smodels"));
        this.solver.setModelLimit(maxModels);
        this.solver.setModelLength(this.getEvolp().getEvents().size());
        TransformedEvolp tmp = this.getTransformedEvolp();
        this.getSW().setMessages("Calling Smodels...", "Evolution stable models computed in");
        this.getSW().start();
        processor.beforeConsuming();
        try {
            this.solver.solve(tmp, processor);
        }
        finally {
            processor.afterConsuming();
        }
        int n = this.solver.getModelCount();
        switch (n) {
            case 0: {
                this.showMessage("No evolution stable model exists");
                break;
            }
            case 1: {
                this.showMessage("1 evolution stable model computed");
                break;
            }
            default: {
                this.showMessage(n + " evolution stable models computed");
            }
        }
        this.getSW().stop();
    }
}

