/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpStructureUnit;
import lp.struct.util.LpHtmlPrinter;
import lp.trans.Consumer;
import lp.ui.ConfigManager;
import lp.ui.EvolpVarProcessor;
import lp.ui.JspPrinter;
import lp.unit.DynamicLogicProgram;
import lp.unit.EvolpProgram;
import lp.unit.EvolutionStableModel;
import lp.unit.StableModel;
import lp.unit.TransDlpRuleType;
import lp.unit.TransformedDlp;

public class EvolpVarWebappHelper
extends EvolpVarProcessor {
    private final JspPrinter printer;
    private final TransEvolpHtmlPrinter<Writer> transPrinter;
    private final EvolpModelProcessor processor;
    private boolean error;

    public EvolpVarWebappHelper(ConfigManager config, JspWriter out) {
        super(config);
        this.printer = new JspPrinter(out);
        this.transPrinter = new TransEvolpHtmlPrinter(this, (Writer)out);
        this.processor = new EvolpModelProcessor();
        this.error = false;
    }

    public void setInput(Reader input) {
        super.setInput(input);
        this.error = false;
    }

    protected void showMessage(String message) {
        this.printer.showMessage(message);
    }

    public boolean isError() {
        return this.error;
    }

    protected void showError(String comment, Exception e) {
        this.printer.showError(comment, e);
        this.error = true;
    }

    public void writeEvolp() {
        if (!this.error) {
            try {
                EvolpProgram tmp = this.getEvolp();
                if (!this.error) {
                    this.printer.append("<div class=\"code\">\n");
                    this.printer.append(tmp);
                    this.printer.append("</div>\n\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't parse input program!", e);
            }
        }
    }

    public void writeEquivDlp() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                DynamicLogicProgram tmp = this.getEquivDlp();
                if (!this.error) {
                    this.printer.append("<div class=\"code\">\n");
                    this.printer.append(tmp);
                    this.printer.append("</div>\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't transform the input program!", e);
            }
        }
    }

    public void writeEquivLp() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                TransformedDlp tmp = this.getEquivLp();
                if (!this.error) {
                    this.transPrinter.append("<div class=\"code\">\n");
                    this.transPrinter.append(tmp);
                    this.transPrinter.append("</div>\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't transform the input program!", e);
            }
        }
    }

    public void writeModels() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                this.chmod("location.smodels");
                this.computeModels(this.processor);
            }
            catch (Exception e) {
                this.showError("Couldn't compute the stable models!", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EvolpModelProcessor
    implements Consumer<EvolutionStableModel> {
        private int n = 0;

        @Override
        public void beforeConsuming() {
            this.n = 0;
        }

        @Override
        public void afterConsuming() {
        }

        @Override
        public void consume(EvolutionStableModel model) {
            ++this.n;
            EvolpVarWebappHelper.this.showMessage("Evolution stable model no. " + this.n + ":");
            EvolpVarWebappHelper.this.printer.println("<div class=\"code\">");
            int i = 1;
            for (StableModel m : model) {
                EvolpVarWebappHelper.this.printer.append("<p class=\"model\">M<sub>" + i + "</sub> = {");
                Iterator iter = m.iterator();
                if (iter.hasNext()) {
                    EvolpVarWebappHelper.this.printer.append((LpStructureUnit)iter.next());
                }
                while (iter.hasNext()) {
                    EvolpVarWebappHelper.this.printer.append(", ");
                    EvolpVarWebappHelper.this.printer.append((LpStructureUnit)iter.next());
                }
                EvolpVarWebappHelper.this.printer.append("}</p>\n");
                ++i;
            }
            EvolpVarWebappHelper.this.printer.println("</div>\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransEvolpHtmlPrinter<W extends Writer>
    extends LpHtmlPrinter<W> {
        final /* synthetic */ EvolpVarWebappHelper this$0;

        public TransEvolpHtmlPrinter(W out) {
            this.this$0 = var1_1;
            super(out, ":-", true);
        }

        public void append(TransformedDlp equivLp) {
            for (TransDlpRuleType t : TransDlpRuleType.values()) {
                this.append("<div class=\"ruleGroup\">\n");
                this.append("<p class=\"comment\">% ");
                this.append(t.toString());
                this.append("</p>\n");
                for (LpRule r : equivLp.getGroup(t)) {
                    this.append(r);
                }
                this.append("</div>\n\n");
            }
        }

        @Override
        public void visit(LpPredicate pred) {
            String name = pred.getName();
            if (name.startsWith("_N")) {
                this.append("<span class=\"negLitPrefix\">_N</span>");
                name = name.substring(2);
            }
            this.append("<span class=\"predicate\">");
            this.append(name);
            this.append("</span>");
        }
    }
}

