/*
 * Decompiled with CFR 0.152.
 */
package lp.ui;

import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;
import lp.struct.LpPredicate;
import lp.struct.LpRule;
import lp.struct.LpStructureUnit;
import lp.struct.util.LpHtmlPrinter;
import lp.trans.Consumer;
import lp.ui.ConfigManager;
import lp.ui.EvolpProcessor;
import lp.ui.JspPrinter;
import lp.unit.EvolpProgram;
import lp.unit.EvolutionStableModel;
import lp.unit.StableModel;
import lp.unit.TransEvolpRuleType;
import lp.unit.TransformedEvolp;

public class EvolpWebappHelper
extends EvolpProcessor {
    private final JspPrinter printer;
    private final TransEvolpHtmlPrinter<Writer> transPrinter;
    private final EvolpModelProcessor processor;
    private boolean error;

    public EvolpWebappHelper(ConfigManager config, JspWriter out) {
        super(config);
        this.printer = new JspPrinter(out);
        this.transPrinter = new TransEvolpHtmlPrinter(this, (Writer)out);
        this.processor = new EvolpModelProcessor();
        this.error = false;
    }

    public void setInput(Reader input) {
        super.setInput(input);
        this.error = false;
    }

    protected void showMessage(String message) {
        this.printer.showMessage(message);
    }

    public boolean isError() {
        return this.error;
    }

    protected void showError(String comment, Exception e) {
        this.printer.showError(comment, e);
        this.error = true;
    }

    public void writeEvolp() {
        if (!this.error) {
            try {
                EvolpProgram tmp = this.getEvolp();
                if (!this.error) {
                    this.printer.append("<div class=\"code\">\n");
                    this.printer.append(tmp);
                    this.printer.append("</div>\n\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't parse input program!", e);
            }
        }
    }

    public void writeTransformedEvolp() {
        if (!this.error) {
            try {
                TransformedEvolp tmp = this.getTransformedEvolp();
                if (!this.error) {
                    this.transPrinter.append("<div class=\"code\">\n");
                    this.transPrinter.append(tmp);
                    this.transPrinter.append("</div>\n");
                }
            }
            catch (Exception e) {
                this.showError("Couldn't transform the input program!", e);
            }
        }
    }

    public void writeModels() {
        if (!this.error) {
            try {
                this.chmod("location.lparse");
                this.chmod("location.smodels");
                this.computeModels(this.processor);
            }
            catch (Exception e) {
                this.showError("Couldn't compute the stable models!", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EvolpModelProcessor
    implements Consumer<EvolutionStableModel> {
        private int n = 0;

        @Override
        public void beforeConsuming() {
            this.n = 0;
        }

        @Override
        public void afterConsuming() {
        }

        @Override
        public void consume(EvolutionStableModel model) {
            ++this.n;
            EvolpWebappHelper.this.showMessage("Evolution stable model no. " + this.n + ":");
            EvolpWebappHelper.this.printer.println("<div class=\"code\">");
            int i = 1;
            for (StableModel m : model) {
                EvolpWebappHelper.this.printer.append("<p class=\"model\">M<sub>" + i + "</sub> = {");
                Iterator iter = m.iterator();
                if (iter.hasNext()) {
                    EvolpWebappHelper.this.printer.append((LpStructureUnit)iter.next());
                }
                while (iter.hasNext()) {
                    EvolpWebappHelper.this.printer.append(", ");
                    EvolpWebappHelper.this.printer.append((LpStructureUnit)iter.next());
                }
                EvolpWebappHelper.this.printer.append("}</p>\n");
                ++i;
            }
            EvolpWebappHelper.this.printer.println("</div>\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransEvolpHtmlPrinter<W extends Writer>
    extends LpHtmlPrinter<W> {
        final /* synthetic */ EvolpWebappHelper this$0;

        public TransEvolpHtmlPrinter(W out) {
            this.this$0 = var1_1;
            super(out, ":-", true);
        }

        public void append(TransformedEvolp transEvolp) {
            for (int group = 1; group <= transEvolp.getMaxGroup(); ++group) {
                for (TransEvolpRuleType t : TransEvolpRuleType.values()) {
                    this.append("<div class=\"ruleGroup\">\n");
                    this.append("<p class=\"comment\">% ");
                    this.append(t.toString());
                    this.append(" in the ");
                    this.append(Integer.toString(group));
                    switch (group) {
                        case 1: {
                            this.append("st");
                            break;
                        }
                        case 2: {
                            this.append("nd");
                            break;
                        }
                        case 3: {
                            this.append("rd");
                            break;
                        }
                        default: {
                            this.append("th");
                        }
                    }
                    this.append(" DLP</p>\n");
                    for (LpRule r : transEvolp.getGroup(group, t)) {
                        this.append(r);
                    }
                    this.append("</div>\n\n");
                }
            }
        }

        @Override
        public void visit(LpPredicate pred) {
            String name = pred.getName();
            if (name.startsWith("_N")) {
                this.append("<span class=\"negLitPrefix\">_N</span>");
                name = name.substring(2);
            }
            this.append("<span class=\"predicate\">");
            this.append(name);
            this.append("</span>");
        }
    }
}

