/*
 * Decompiled with CFR 0.152.
 */
package lp.wrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lp.wrap.LparseMessage;
import lp.wrap.WrapperException;
import lp.wrap.WrapperUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LparseWrapper {
    private static final WrapperUtils WU = WrapperUtils.getInstance();
    private String lparsePath = "lparse";
    private String options = "";
    private Process process = null;
    private final ErrorStreamProcessor errorProcessor = new ErrorStreamProcessor();
    private Thread errorThread = null;
    private LparseMessage error = null;
    private final List<LparseMessage> warnings = new ArrayList<LparseMessage>();

    public void setLparsePath(String lparsePath) {
        if (lparsePath == null || "".equals(lparsePath)) {
            throw new IllegalArgumentException("The path to lparse must not be null or empty!");
        }
        this.lparsePath = lparsePath;
    }

    public LparseWrapper setOptions(String options) {
        this.options = options == null ? "" : options;
        return this;
    }

    public void exec() {
        this.process = WU.exec(this.lparsePath + " " + this.options);
        this.errorProcessor.setErrorStream(this.process.getErrorStream());
        this.errorThread = new Thread(this.errorProcessor);
        this.errorThread.start();
    }

    public OutputStream getStdin() {
        return this.process.getOutputStream();
    }

    public void closeStdin() {
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException e) {
            throw new WrapperException("Error while closing the standard input stream of the lparse process", e);
        }
    }

    public InputStream getStdout() {
        return this.process.getInputStream();
    }

    public int waitFor() {
        try {
            this.errorThread.join();
        }
        catch (InterruptedException e) {
            throw new WrapperException("A thread reading standard error output of the process was interrupted!", e);
        }
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new WrapperException("The process was interrupted!", e);
        }
    }

    public LparseMessage getError() {
        return this.error;
    }

    public List<LparseMessage> getWarnings() {
        return this.warnings;
    }

    private class ErrorStreamProcessor
    implements Runnable {
        private InputStream stream = null;

        public void setErrorStream(InputStream input) {
            this.stream = input;
            LparseWrapper.this.error = null;
            LparseWrapper.this.warnings.clear();
        }

        public void run() {
            try {
                this.parseMessages();
            }
            catch (IOException e) {
                throw new WrapperException("An I/O error occured while reading the standard error input!", e);
            }
        }

        private void parseMessages() throws IOException {
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(this.stream));
            LparseMessage current = null;
            String line = stderrReader.readLine();
            boolean isEmptyStderr = true;
            StringBuilder message = new StringBuilder();
            while (line != null) {
                int firstColon;
                boolean isWarning = true;
                if (!"".equals(line.trim())) {
                    isEmptyStderr = false;
                }
                if ((firstColon = line.indexOf(58)) == -1) {
                    line = stderrReader.readLine();
                    continue;
                }
                int lineNumber = Integer.valueOf(line.substring(0, firstColon));
                String rest = line.substring(firstColon + 1);
                int warningPos = rest.indexOf("Warning:");
                if (warningPos == -1) {
                    isWarning = false;
                    int errorPos = rest.indexOf("Error:");
                    if (errorPos != -1) {
                        rest = rest.substring(errorPos + "Error:".length());
                    }
                } else {
                    rest = rest.substring(warningPos + "Warning:".length());
                }
                rest = rest.trim();
                message.setLength(0);
                message.append(Character.toUpperCase(rest.charAt(0)));
                message.append(rest.substring(1));
                line = stderrReader.readLine();
                while (line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0))) {
                    message.append(' ');
                    line = line.trim();
                    if (message.charAt(message.length() - 2) == '.') {
                        message.append(Character.toUpperCase(line.charAt(0)));
                        message.append(line.substring(1));
                    } else {
                        message.append(line);
                    }
                    line = stderrReader.readLine();
                }
                current = new LparseMessage(message.toString(), lineNumber, isWarning);
                if (isWarning) {
                    LparseWrapper.this.warnings.add(current);
                    continue;
                }
                LparseWrapper.this.error = current;
            }
            if (!isEmptyStderr && LparseWrapper.this.error == null && LparseWrapper.this.warnings.isEmpty()) {
                LparseWrapper.this.error = new LparseMessage(null, -1);
            }
        }
    }
}

