/*
 * Decompiled with CFR 0.152.
 */
package lp.wrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lp.wrap.WrapperException;
import lp.wrap.WrapperUtils;

public class SmodelsWrapper {
    private static final WrapperUtils WU = WrapperUtils.getInstance();
    private String smodelsPath = "smodels";
    private int modelLimit = 0;
    private Process process;

    public void setSmodelsPath(String smodelsPath) {
        if (smodelsPath == null || "".equals(smodelsPath)) {
            throw new IllegalArgumentException("The path to smodels must not be null or empty!");
        }
        this.smodelsPath = smodelsPath;
    }

    public SmodelsWrapper setModelLimit(int modelLimit) {
        if (modelLimit < 0) {
            throw new IllegalArgumentException("The number of models must be non-negative!");
        }
        this.modelLimit = modelLimit;
        return this;
    }

    public void exec() {
        this.process = WU.exec(this.smodelsPath + " " + this.modelLimit);
    }

    public OutputStream getStdin() {
        return this.process.getOutputStream();
    }

    public void closeStdin() {
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException e) {
            throw new WrapperException("Error while closing the standard input stream of the lparse process", e);
        }
    }

    public InputStream getStdout() {
        return this.process.getInputStream();
    }

    public int waitFor() {
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new WrapperException("The process was interrupted!", e);
        }
    }
}

