/*
 * Decompiled with CFR 0.152.
 */
package lp.wrap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import lp.util.ExceptionAdapter;
import lp.wrap.WrapperException;

public class WrapperUtils {
    private final byte[] byteBuffer = new byte[8192];
    private final char[] charBuffer = new char[8192];
    private static WrapperUtils instance = null;

    public static synchronized WrapperUtils getInstance() {
        if (instance == null) {
            instance = new WrapperUtils();
        }
        return instance;
    }

    private WrapperUtils() {
    }

    public String getCommandName(String command) {
        if (command == null) {
            return null;
        }
        return new StringTokenizer(command).nextToken();
    }

    public String getShortCommandName(String command) {
        if (command == null) {
            return null;
        }
        String name = this.getCommandName(command);
        int lastSlash = name.lastIndexOf(File.separatorChar);
        if (lastSlash == -1) {
            return name;
        }
        return name.substring(lastSlash + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(InputStream from, OutputStream to) {
        if (from == null) {
            return;
        }
        try {
            byte[] byArray = this.byteBuffer;
            synchronized (this.byteBuffer) {
                int numRead = from.read(this.byteBuffer);
                while (numRead != -1) {
                    to.write(this.byteBuffer, 0, numRead);
                    numRead = from.read(this.byteBuffer);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                from.close();
            }
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
    }

    public void transfer(String from, OutputStream to) {
        if (from == null) {
            return;
        }
        this.transfer((InputStream)new ByteArrayInputStream(from.getBytes()), to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder transfer(InputStream from, StringBuilder to) {
        if (from == null) {
            return to;
        }
        InputStreamReader reader = new InputStreamReader(from);
        try {
            char[] cArray = this.charBuffer;
            synchronized (this.charBuffer) {
                int numRead = reader.read(this.charBuffer);
                while (numRead != -1) {
                    to.append(this.charBuffer, 0, numRead);
                    numRead = reader.read(this.charBuffer);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                from.close();
            }
        }
        catch (IOException e) {
            throw new ExceptionAdapter(e);
        }
        return to;
    }

    public String dumpToString(InputStream from) {
        return this.transfer(from, new StringBuilder()).toString();
    }

    public Process exec(String command) throws WrapperException {
        try {
            return Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new WrapperException(this.getShortCommandName(command) + " could not be executed " + "(path `" + this.getCommandName(command) + "' is probably invalid)", e);
        }
    }
}

