/*
 * LpToken.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (???): initial version
 * v0.2 (2007-01-01): implementation, tests, documentation
 * 1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.parse;

/**
 * An immutable container for information about 1 token in an input created by
 * a {@link LpLexer}. Contains a type, the corresponding lexem, line number and
 * the position within the line.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpLexer
 * @see LpTokenType
 */
public class LpToken {
	/**
	 * Type of the token.
	 */
	private final LpTokenType type;
	
	/**
	 * The corresponding lexem.
	 */
	private final String lexem;
	
	/**
	 * Number of the line where the token occurs. Lines are numbered from 1.
	 */
	private final int lineNumber;
	
	/**
	 * Position within the line where the token occurs. Numbered from 1.
	 */
	private final int position;
	
	/**
	 * Creates a new instance.
	 *
	 * @param type type of the token.
	 * @param lexem the corresponding lexem.
	 * @param lineNumber number of the line where the token occurs.
	 * @param position position within the line where the token occurs.
	 */
	public LpToken(LpTokenType type, String lexem, int lineNumber, int position) {
		this.type = type;
		this.lexem = lexem;
		this.position = position;
		this.lineNumber = lineNumber;
	}
	
	/**
	 * Returns the type of the token.
	 *
	 * @return the type of the token
	 */
	public LpTokenType getType() {
		return type;
	}
	
	/**
	 * Returns the corresponding lexem.
	 *
	 * @return the corresponding lexem.
	 */
	public String getLexem() {
		return lexem;
	}
	
	/**
	 * Returns the number of the line where the token occurs.
	 *
	 * @return the number of the line where the token occurs.
	 */
	public int getPosition() {
		return position;
	}
	
	/**
	 * Returns the position within the line where the token occurs.
	 *
	 * @return the position within the line where the token occurs.
	 */
	public int getLineNumber() {
		return lineNumber;
	}
}