/*
 * LpTokenType.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.2 (2006-12-27): taken from propositional EVOLP implementation
 * 1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.parse;

/**
 * Enumeration of token types returned by a {@link LpLexer} and further used by
 * parsers to parse source code.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpLexer#getTokenType()
 */
public enum LpTokenType {
	/**
	 * A left parenthesis.
	 */
	LEFT_PAREN("\"(\""),
	
	/**
	 * A right parenthesis.
	 */
	RIGHT_PAREN("\")\""),
	
	/**
	 * A comma.
	 */
	COMMA("\",\""),
	
	/**
	 * A dot.
	 */
	DOT("\".\""),
	
	/**
	 * An arrow separating a rule's head from a rule's body.
	 */
	RULE_ARROW("\"<-\""),
	
	/**
	 * Any string of letters, numbers and underscores not beginning with an
	 * uppercase letter. See {@link LpLexer} for details.
	 */
	LOWERCASE_WORD("a word starting with a lower case letter"),
	
	/**
	 * Any string of letters, numbers and underscores beginning with an
	 * uppercase letter. See {@link LpLexer} for details.
	 */
	UPPERCASE_WORD("a word starting with an upper case letter"),
	
	/**
	 * Returned when the end of input is reached.
	 */
	EOF("end of file"),
	
	/**
	 * Everything that does not fit into some of the previous categories is
	 * identified as this token type.
	 */
	UNKNOWN_CHAR("unknown character");
	
	/**
	 * Description of the token.
	 */
	private final String description;
	
	/**
	 * Enumeration constructor taking care of remembering the description.
	 *
	 * @param description
	 */
	private LpTokenType(String description) {
		this.description = description;
	}
	
	/**
	 * Getter method for the description.
	 *
	 * @return token type description
	 */
	public String getDescription() {
		return description;
	}
}