/*
 * LpStructureUnit.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-04): initial version
 * v0.2 (2007-01-04):
 * - the 3 normalForm methods added, documented and testing utils added to
 *   LpStructureUnitTestUtils.java
 * - toString added and documented (cannot be tested at this level)
 * v0.2.2 (2007-01-05):
 * - became an interface with implementation in LpAbstractStructureUnit
 * v0.2.3 (2007-01-12):
 * - NullPointerException replaced by IllegalArgumentException in
 *   appendNormalForm methods
 * - the keyword "public" removed (ignored in an interface)
 * v0.2.4 (2007-01-18):
 * - appenNormalForm() and getNormalForm() deleted, the same functionality now
 *   provided by LpPrettyPrinter
 * - accept(LpStructureUnit) added (visitor pattern...)
 * - documentation updated
 * v1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.struct;

/**
 * An interface providing the {@link #accept(LpStructureUnitVisitor)} method
 * that make implementing classes visitable by any
 * {@link LpStructureUnitVisitor}.
 *
 * The implementing classes are object representations of the structure of a
 * logic program.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpAbstractStructureUnit
 * @see LpConstant
 * @see LpVariable
 * @see LpCompoundTerm
 * @see LpFunction
 * @see LpPredicate
 * @see LpLiteral
 * @see LpRule
 * @see lp.struct.util.LpPrinter
 */
public interface LpStructureUnit {
	/**
	 * Makes the implementing classes visitable by a
	 * {@code LpStructureUnitVisitor}. The implementing method should (at least)
	 * call {@code visitor.visit(this)}.
	 *
	 * @param visitor the accepted {@code LpStructureUnitVisitor}
	 */
	void accept(LpStructureUnitVisitor visitor);
}