/*
 * LpStructureUnitVisitor.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-18): initial version
 * v0.2 (2007-01-18):
 * - the 7 basic methods added
 * - documentation added
 * v0.2.1 (2007-02-11):
 * - a visiting method for the new LpAtom class added
 * v1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.struct;

/**
 * Classes implementing this interface can act as visitors of classes
 * implementing the {@link LpStructureUnit} interface.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see lp.struct.util.LpPrinter
 * @see lp.struct.util.LpGroundDecider
 */
public interface LpStructureUnitVisitor {
	/**
	 * A method for visiting a {@code LpConstant}.
	 *
	 * @param con the {@code LpConstant} to visit
	 */
	void visit(LpConstant con);
	
	/**
	 * A method for visiting a {@code LpVariable}.
	 *
	 * @param var the {@code LpVariable} to visit
	 */
	void visit(LpVariable var);
	
	/**
	 * A method for visiting a {@code LpFunction}.
	 *
	 * @param fun the {@code LpFunction} to visit
	 */
	void visit(LpFunction fun);
	
	/**
	 * A method for visiting a {@code LpCompoundTerm}.
	 *
	 * @param term the {@code LpCompoundTerm} to visit
	 */
	void visit(LpCompoundTerm term);
	
	/**
	 * A method for visiting a {@code LpPredicate}.
	 *
	 * @param pred the {@code LpPredicate} to visit
	 */
	void visit(LpPredicate pred);
	
	/**
	 * A method for visiting atom {@code LpAtom}.
	 *
	 * @param atom the {@code LpAtom} to visit
	 */
	void visit(LpAtom atom);
	
	/**
	 * A method for visiting a {@code LpLiteral}.
	 *
	 * @param lit the {@code LpLiteral} to visit
	 */
	void visit(LpLiteral lit);
	
	/**
	 * A method for visiting a {@code LpRule}.
	 *
	 * @param rule the {@code LpRule} to visit
	 */
	void visit(LpRule rule);
}