/*
 * LpTerm.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-02): initial version
 * v0.2 (2007-01-02): documented
 * v0.2.2 (2007-01-05): added "extends LpStructureUnit" declaration
 * v0.2.3 (2007-01-12):
 * - the keyword "public" removed (ignored in an interface)
 * v1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.struct;

/**
 * Represents a term in logic programming. A term is either a constant, a
 * variable or a compound term that consists o a function symbol and its
 * arguments&#8212;terms. Terms represent inviduals that can be put into
 * relationships using predicate symbols.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpConstant
 * @see LpVariable
 * @see LpCompoundTerm
 * @see LpRule
 * @see LpLiteral
 */
public interface LpTerm extends LpStructureUnit {
	/**
	 * Returns {@code true} if and only if {@code obj} is a term of the same
	 * structure.
	 *
	 * @param obj the object to compare with
	 * @return {@code true} if this object is equal to {@code obj} according to
	 * the description above, and {@code false} otherwise
	 * @see LpConstant#equals(Object)
	 * @see LpVariable#equals(Object)
	 * @see LpCompoundTerm#equals(Object)
	 */
	@Override
	boolean equals(Object obj);
	
	/**
	 * Overriden in order to maintain the general contract of
	 * {@link Object#hashCode()}.
	 *
	 * @return the hash of this object
	 * @see LpConstant#hashCode()
	 * @see LpVariable#hashCode()
	 * @see LpCompoundTerm#hashCode()
	 */
	@Override
	int hashCode();
}