/*
 * Consumer.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v1.0.0 (2007-05-06):
 * - no version information kept before :P
 */

package lp.trans;

/**
 * Implementors of this interface can process instances of a specific class.
 * It is used to process stable models as they are generated by smodels so that,
 * in case there are many models, they don't have to be remembered in the memory
 * until we have all of them. Instead of that they are passed one by one the a
 * model consumer.
 *
 * @author Martin Slota
 * @version 1.0.0
 *
 */
public interface Consumer<I> {
	/**
	 * Consume {@code item}.
	 *
	 * @param item the item to consume
	 */
	void consume(I item);
	
	/**
	 * If the consumer is used to process a sequence of instances, this method
	 * should be called before the sequence begins.
	 */
	void beforeConsuming();
	
	/**
	 * If the consumer is used to process a sequence of instances, this method
	 * should be called after the sequence ends.
	 */
	void afterConsuming();
}