/*
 * AbstractProcessor.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.9.0 (2007-05-07):
 * - extracted from EvolpProcessor
 *
 * TODO docs
 * PENDING create a junit test
 */

package lp.ui;

/**
 * An abstract class with a set of methods common for {@link DlpProcessor},
 * {@link EvolpProcessor} and {@link EvolpVarProcessor}.
 *
 * @author Martin Slota
 * @version 0.9.0
 */
public abstract class AbstractProcessor {
	private final StopWatch sw;
	
	private final ConfigManager config;
	
	public AbstractProcessor(ConfigManager config) {
		this.config = config;
		sw = new StopWatch();
	}
	
	
	protected ConfigManager getConfig() {
		return config;
	}
	
	protected StopWatch getSW() {
		return sw;
	}
	
	protected abstract void showMessage(String message);
	
	protected void chmod(String key) {
		try {
			Process p = Runtime.getRuntime().exec(
					"/bin/chmod +x " + getConfig().getProperty(key));
			p.waitFor();
			//showMessage("successfully changed permissions for " + key);
		} catch (Exception e) {
			// don't care :o)
			//showMessage("!! unsuccessfully changed permissions for " + key);
			//showMessage(e.getMessage());
		}
	}
	
	public static String escapeXMLSpecials(String input) {
		StringBuilder sb = new StringBuilder();
		int length = input.length();
		for (int i = 0; i < length; i++) {
			char c = input.charAt(i);
			switch (c) {
				case '&':
					sb.append("&amp;");
					break;
				case '<':
					sb.append("&lt;");
					break;
				case '>':
					sb.append("&gt;");
					break;
				case '"':
					sb.append("&quot;");
					break;
				case '\'':
					sb.append("&apos;");
					break;
				default: sb.append(c);
			}
		}
		return sb.toString();
	}
	
	protected class StopWatch {
		private String before;
		
		private String after;
		
		private long time;
		
		public StopWatch() {
			this.before = before;
			this.after = after;
		}
		
		public void setMessages(String before, String after) {
			this.before = before;
			this.after = after;
		}
		
		public void start() {
			showMessage(before);
			time = System.currentTimeMillis();
		}
		
		public void stop() {
			long duration = System.currentTimeMillis() - time;
			int sec = (int) (duration / 1000);
			int millis = (int) (duration % 1000);
			String millisFormated;
			if (millis < 10)
				millisFormated = "00" + millis;
			else if (millis < 100)
				millisFormated = "0" + millis;
			else
				millisFormated = Integer.toString(millis);
			showMessage(after + " " + sec + "." + millisFormated + "s");
		}
	}
}