/*
 * JspPrinter.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.9.0 (2007-05-07):
 * - no version information kept before :o)
 *
 * TODO docs
 * PENDING create a junit test
 */

package lp.ui;

import java.io.PrintWriter;
import javax.servlet.jsp.JspWriter;
import lp.struct.util.LpHtmlPrinter;
import lp.util.ExceptionAdapter;

/**
 * A helper class for printing logic programs and messages in HTML to a 
 * {@link JspWriter}.
 *
 * @author Martin Slota
 * @version 0.9.0
 */
public class JspPrinter extends LpHtmlPrinter<JspWriter> {
	private static final boolean QUIET = true;
	
	public JspPrinter(JspWriter out) {
		super(out, "<-", true);
	}
	
	public void println(String line) {
		append(line);
		append('\n');
	}
	
	public void showMessage(String message) {
		println("<p class=\"message\">-- " + 
				AbstractProcessor.escapeXMLSpecials(message) + "</p>");
	}
	
	public void showError(String comment, Exception e) {
		println("<p class=\"error\">!! " +
				AbstractProcessor.escapeXMLSpecials(comment) + "</p>");
		String message = (e instanceof ExceptionAdapter) ?
			e.getCause().getMessage() : e.getMessage();
		println("<p class=\"error\">!! Error: " + message + "</p>");
		if (!QUIET) {
			println("<pre>");
			e.printStackTrace(new PrintWriter(this));
			println("</pre>");
		}
	}
}