/*
 * EvolpProgram.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v1.0.0 (2007-05-05):
 * - no version information kept before :P
 *
 * PENDING create a junit test
 */

package lp.unit;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents an evolving logic program (the base program) with a sequence of
 * events (also evolving logic programs).
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LogicProgram
 * @see GeneralizedLogicProgram
 */
public class EvolpProgram {
	/**
	 * The base logic program.
	 */
	private LogicProgram baseProgram;
	
	/**
	 * The sequence of events.
	 */
	private final List<LogicProgram> events;
	
	/**
	 * Creates a new instance of {@code EvolpProgram}
	 */
	public EvolpProgram() {
		events = new ArrayList<LogicProgram>();
	}
	
	/**
	 * Returns the base program.
	 *
	 * @return the base program
	 */
	public LogicProgram getBaseProgram() {
		return baseProgram;
	}
	
	/**
	 * Sets {@code program} as the base program.
	 *
	 * @param program the new base program
	 */
	public void setBaseProgram(LogicProgram program) {
		baseProgram = program;
	}
	
	/**
	 * Returns the event sequence.
	 *
	 * @return the event sequence
	 */
	public List<LogicProgram> getEvents() {
		return events;
	}
	
	/**
	 * Adds a new event to the end of the event sequence.
	 *
	 * @param program the event to be added
	 */
	public void addEvent(LogicProgram program) {
		events.add(program);
	}
	
	/**
	 * Returns {@code true} iff both the base program and all events are ground.
	 *
	 * @return as specified above
	 * @see LogicProgram#isGround()
	 */
	public boolean isGround() {
		if (!baseProgram.isGround())
			return false;
		for (LogicProgram prog : events)
			if (!prog.isGround())
				return false;
		return true;
	}
}