/*
 * EvolutionStableModel.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-04-25): initial version
 * v1.0.0 (2007-05-05):
 * - documentation added
 *
 * PENDING create a junit test
 */

package lp.unit;

import java.util.ArrayList;

/**
 * Represents an evolution stable model, i.e. a sequence of stable models.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see StableModel
 */
public class EvolutionStableModel extends ArrayList<StableModel> {
	/**
	 * Creates a new instance of {@code EvolutionStableModel}.
	 */
	public EvolutionStableModel() {
		super();
	}
	
	/**
	 * Creates a new instance of {@code EvolutionStableModel} with the given
	 * initial capacity.
	 *
	 * @param initialCapacity the initial capacity of this {@link ArrayList}
	 */
	public EvolutionStableModel(int initialCapacity) {
		super(initialCapacity);
	}
}