/*
 * LogicProgram.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-15): initial version
 * v0.2 (2007-01-28):
 * - equals and hashCode overridden
 * - documentation added
 * v0.2.1 (2007-01-29):
 * - the isGround() method added, documented
 * v0.2.2 (2007-02-08):
 * - toString() added
 * - some tests added
 * v0.2.3 (2007-02-12):
 * - moved to lp.unit package
 * v0.2.4 (2007-02-12):
 * - converted to an interface, implementation moved to DefaultLogicProgram
 * v0.2.5 (2007-02-14):
 * - now extends only Collection<LpRule>, not List<LpRule>
 * v0.2.6 (2007-03-06):
 * - now extends Set<LpRule>
 * - equals declaration removed (the one from Set is OK)
 * v1.0.0 (2007-05-05):
 * - promoted to version 1.0.0 :o)
 */

package lp.unit;

import java.util.Set;
import lp.struct.LpRule;

/**
 * Represents an ordinary logic program, i.e. a set of logic program rules
 * represented by {@link LpRule} instances.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpRule
 */
public interface LogicProgram extends Set<LpRule> {
	/**
	 * Returns the {@code i}-th rule in this logic program. Rules are required
	 * to be in the order they were added to the program (just like in a list) .
	 * But this order is not important when determining if two logic programs
	 * are equal. Multiple appearance of one rule is also not important in this
	 * respect.
	 */
	LpRule get(int index);
	
	/**
	 * Returns {@code true} iff this logic programs contains only ground rules,
	 * i.e. rules that contain no variables.
	 *
	 * @return as specified above
	 * @see lp.struct.util.LpGroundDecider#isGround(LpStructureUnit)
	 */
	boolean isGround();
}