/*
 * StableModel.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-02-12): initial version
 * v0.1.1 (2007-02-14):
 * - comparator added
 * v1.0.0 (2007-05-05):
 * - documentation added
 *
 * PENDING create a junit test
 */

package lp.unit;

import java.util.Comparator;
import java.util.TreeSet;
import lp.struct.LpAtom;

/**
 * Represents a stable model, i.e. a set of atoms.
 *
 * @author Martin Slota
 * @version 1.0.0
 */
public class StableModel extends TreeSet<LpAtom> {
	/**
	 * A comparator that compares atoms according to their standard string
	 * representations.
	 */
	private static final Comparator<LpAtom> SM_COMPARATOR =
			new Comparator<LpAtom>() {
		public int compare(LpAtom a1, LpAtom a2) {
			String s1 = a1.toString();
			String s2 = a2.toString();
			return s1.compareTo(s2);
		}
	};
	
	/**
	 * Creates a new instance of {@code StableModel}.
	 */
	public StableModel() {
		super(SM_COMPARATOR);
	}
}