/*
 * TransEvolpRuleType.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-02-20): initial version
 * v1.0.0 (2007-05-05):
 * - documentation added
 */

package lp.unit;

/**
 * Enumeration of types of rules in a normal logic program equivalent to an
 * evolving logic program.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see TransformedEvolp
 * @see EvolpProgram
 */
public enum TransEvolpRuleType {
	/**
	 * Rewritten rule from the base evolving logic program.
	 */
	REWRITTEN_PROGRAM_RULE("Rewritten program rules"),
	
	/**
	 * Rewritten rule from one of the events.
	 */
	REWRITTEN_EVENT_RULE("Rewritten event rules"),
	
	/**
	 * Rule that can be asserted.
	 */
	ASSERTABLE_RULE("Assertable rules"),
	
	/**
	 * Rule that, based on a rule of the original program, prevents other rules
	 * with an opposite head from being fired (rejects them).
	 */
	INTRO_REJECTION("Rules for introducing rejections"),
	
	/**
	 * Rule that propagates the rejection to even less preferred rules.
	 */
	PROPAGATION_REJECTION("Rules for propagating rejections"),
	
	/**
	 * A rule with a default assumption.
	 */
	DEFAULT_RULE("Default assumptions"),
	
	/**
	 * A constraint that discards superfluous models of the transformed program.
	 */
	CONSTRAINT("Totality constraints");
	
	/**
	 * A label for the rule type.
	 */
	private final String label;
	
	/**
	 * A private enum constructore that sets the label for the rule type.
	 *
	 * @param label the rule type's label
	 */
	private TransEvolpRuleType(String label) {
		this.label = label;
	}
	
	/**
	 * Returns a short description of the rule type.
	 *
	 * @return as specified above
	 */
	@Override
	public String toString() {
		return label;
	}
}