/*
 * ExceptionAdapter.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-28): initial version
 * v0.2 (2007-01-28):
 * - documentation added
 * v1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.util;

/**
 * A {@code RuntimeException} container for checked exceptions. Should be used
 * fake the checked exception mechanism in Java. See
 * <a href="http://www.mindview.net/Etc/Discussions/CheckedExceptions">this article</a>
 * for some arguments why this could be a good idea ;o)
 *
 * @author Martin Slota
 * @version 1.0.0
 */
public class ExceptionAdapter extends RuntimeException {
	/**
	 * Creates a new instance of {@code ExceptionAdapter} that stores
	 * {@code cause} as its cause.
	 *
	 * @param cause the exception to wrap
	 */
	public ExceptionAdapter(Exception cause) {
		super(cause.getMessage(), cause);
	}
	
	/**
	 * Rethrows the original exception.
	 *
	 * @throws Exception the original exception
	 */
	public void rethrow() throws Exception {
		throw (Exception)getCause();
	}
}