/*
 * WrapperException.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-12): initial version
 * v0.2 (2007-01-14):
 * - the 3 standard exception constructors added
 * - documentation added
 * v0.2.1 (2007-01-28):
 * - changed to an unchecked exception (see
 *   http://www.mindview.net/Etc/Discussions/CheckedExceptions)
 * v1.0.0 (2007-05-04):
 * - promoted to version 1.0.0 :o)
 */

package lp.wrap;

/**
 * An exception thrown by {@link LparseWrapper} and {@link SmodelsWrapper} when
 * there are problems while invoking an external command with the desired
 * command line options, environment variables and standard input or while
 * reading the standard/error output of the resulting {@link Process} instance
 * or waiting for the process to finish execution.
 *
 * @author Martin Slota
 * @version 1.0.0
 */
public class WrapperException extends RuntimeException {
	/**
	 * Constructs a {@code WrapperException} with the specified detail message.
	 *
	 * @param message the detail message (which is saved for later retrieval
	 * by the {@link #getMessage()} method)
	 */
	public WrapperException(String message) {
		super(message);
	}
	
	/**
	 * Constructs a {@code WrapperException} with the specified detail message
	 * and cause.
	 *
	 * Note that the detail message associated with {@code cause} is
	 * <i>not</i> automatically incorporated into this exception's detail
	 * message.
	 *
	 * @param message the detail message (which is saved for later retrieval
	 * by the {@link #getMessage()} method)
	 *
	 * @param cause the cause (which is saved for later retrieval by the
	 * {@link #getCause()} method). (A null value is permitted, and indicates
	 * that the cause is nonexistent or unknown.)
	 */
	public WrapperException(String message, Throwable cause) {
		super(message, cause);
	}
	
	/**
	 * Constructs a {@code WrapperException} with the specified cause and a
	 * detail message of {@code (cause==null ? null : cause.toString())}
	 * (which typically contains the class and detail message of {@code cause}).
	 * This constructor is useful for wrapper exceptions that are little more
	 * than wrappers for other throwables.
	 *
	 * @param cause the cause (which is saved for later retrieval by the
	 * {@link #getCause()} method). (A null value is permitted, and indicates
	 * that the cause is nonexistent or unknown.)
	 */
	public WrapperException(Throwable cause) {
		super(cause);
	}
}