/*
 * DlpParserTest.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-03-05): initial version
 * v0.2 (2007-03-05): testParseDlp added
 * v1.0.0 (2007-05-05):
 * - promoted to version 1.0.0 :o)
 *
 * PENDING add more test cases
 */

package lp.parse;

import lp.unit.DynamicLogicProgram;
import lp.unit.LogicProgram;

/**
 * Contains tests of the {@link DlpParser} class.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see DlpParser
 */
public class DlpParserTest extends LpParserTest {
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	public DlpParserTest(String testName) {
		super(testName);
		parser = new DlpParser();
	}
	
	/**
	 * Tests the {@link DlpParser#parseDlp()} method.
	 */
	public void testParseDlp() {
		String dynprogSource = "a. b.\n" +
				"newProgram.\n" +
				"not a. not b.\n" +
				"newProgram.\n" +
				"a <- b. b <- a.";
		String [] progSources = {
			"a. b.",
			"not a. not b.",
			"a <- b. b <- a."
		};
		
		parser.setInput(dynprogSource);
		DynamicLogicProgram dynprog = ((DlpParser)parser).parseDlp();
		
		int i = 0;
		for (String progSource : progSources) {
			parser.setInput(progSource);
			LogicProgram prog = parser.parseAllRules();
			assertEquals("Dynamic logic program parsed incorrectly!",
					prog, dynprog.get(i));
			i++;
		}
		assertEquals("Dynamic logic program parsed incorrectly!",
				i, dynprog.size());
	}
}