/*
 * EvolpParserTest2.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v1.0.0 (2007-05-05):
 * - initial version, doTest moved here from EvolpParserTest2
 */

package lp.parse;

import lp.struct.LpLiteral;
import lp.struct.LpRule;
import lp.struct.LpStructureUnit;
import lp.struct.LpTerm;
import lp.struct.util.LpPrettyPrinterTest;

/**
 * Contains a test of the {@link LpParser} class that reuses data from 
 * {@link LpPrettyPrinterTest}.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpParser
 * @see LpPrettyPrinterTest
 */
public class LpParserTest2 extends LpPrettyPrinterTest {
	/**
	 * The {@link LpParser} instance used in the tests.
	 */
	protected LpParser parser;
	
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	public LpParserTest2(String testName) {
		super(testName);
		parser = new LpParser();
	}
	
	/**
	 * Gives {@code source} to the parser and expects {@code expected} to be 
	 * returned. Only does something if {@code expected} is an instance of 
	 * {@link LpRule}, {@link LpTerm} or {@link LpLiteral}.
	 * 
	 * @param source the source string that will be parser
	 * @param expected the expected {@link LpStructureUnit}
	 */
	protected void doTest(String source, LpStructureUnit expected) {
		if (expected instanceof LpRule) {
			parser.setInput(source);
			LpRule parsedRule = parser.parseRule();
			parser.close();
			assertEquals("The parsed rule not as expected!",
					expected, parsedRule);
		} else if (expected instanceof LpTerm) {
			parser.setInput(source);
			LpTerm parsedTerm = parser.parseTerm();
			parser.close();
			assertEquals("The parsed term not as expected!",
					expected, parsedTerm);
		} else if (expected instanceof LpLiteral) {
			parser.setInput(source);
			LpLiteral parsedLiteral = parser.parseLiteral();
			parser.close();
			assertEquals("The parsed literal not as expected!", 
					expected, parsedLiteral);
		}
	}
}