/*
 * LpTokenTest.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (???): initial version
 * v0.2 (2007-01-02):
 * - testGetters added
 * - documentation added
 * v0.2.1 (2007-01-12):
 * - assertion messages added in testGetters
 * v1.0.0 (2007-05-05):
 * - promoted to version 1.0.0 :o)
 */

package lp.parse;

import junit.framework.*;

import static lp.parse.LpTokenType.*;

/**
 * Contains tests of the {@link LpToken} class.
 * 
 * 
 * @author Martin Slota
 * @version 1.0.0
 * @see LpToken
 */
public class LpTokenTest extends TestCase {
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	public LpTokenTest(String testName) {
		super(testName);
	}
	
	/**
	 * Tests the getter methods.
	 */
	public void testGetters() {
		LpToken instance = new LpToken(LOWERCASE_WORD, "a_word", 2, 1);
		
		assertEquals("A different token type expected!",
				LOWERCASE_WORD, instance.getType());
		assertEquals("A different lexem expected!",
				"a_word", instance.getLexem());
		assertEquals("A different line number expected!",
				2, instance.getLineNumber());
		assertEquals("A different position expected!",
				1, instance.getPosition());
	}
}