/*
 * LpAbstractStructureUnitTest.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-03-06): initial version
 * v0.2 (2007-03-06):
 * - testToUnmodifiableList added
 * - docs
 * v1.0.0 (2007-05-05):
 * - testToUnmodifiableSet added
 */

package lp.struct;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import junit.framework.*;

/**
 * Contains tests of the {@link LpAbstractStructureUnit} class.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpAbstractStructureUnit
 */
public class LpAbstractStructureUnitTest extends TestCase {
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	public LpAbstractStructureUnitTest(String testName) {
		super(testName);
	}
	
	/**
	 * Tests the {@link LpAbstractStructureUnit#toUnmodifiableList(List)}
	 * method.
	 */
	public void testToUnmodifiableList() {
		List<String> result = LpAbstractStructureUnit.toUnmodifiableList(null);
		assertEquals("An empty list expected!",
				new ArrayList<String>(), result);
		try {
			result.add("abcd");
			fail("An UnsupportedOperationException expected!");
		} catch (UnsupportedOperationException e) {
			// ignore the expected exception
		}
		
		List<String> list = new ArrayList<String>();
		list.add("a");
		list.add("b");
		list.add("c");
		
		result = LpAbstractStructureUnit.toUnmodifiableList(list);
		assertEquals("The resulting list should be equal to the input list!",
				list, result);
		assertFalse("The lists should not be identical!", list == result);
		try {
			result.add("abcd");
			fail("An UnsupportedOperationException expected!");
		} catch (UnsupportedOperationException e) {
			// ignore the expected exception
		}
		
		List<String> result2 =
				LpAbstractStructureUnit.toUnmodifiableList(result);
		assertTrue("The lists should be identical!", result == result2);
	}
	
	/**
	 * Tests the {@link LpAbstractStructureUnit#toUnmodifiableSet(Set)}
	 * method.
	 */
	public void testToUnmodifiableSet() {
		Set<String> result = LpAbstractStructureUnit.toUnmodifiableSet(null);
		assertEquals("An empty setexpected!", new HashSet<String>(), result);
		try {
			result.add("abcd");
			fail("An UnsupportedOperationException expected!");
		} catch (UnsupportedOperationException e) {
			// ignore the expected exception
		}
		
		Set<String> set = new HashSet<String>();
		set.add("a");
		set.add("b");
		set.add("c");
		
		result = LpAbstractStructureUnit.toUnmodifiableSet(set);
		assertEquals("The resulting set should be equal to the input set!",
				set, result);
		assertFalse("The sets should not be identical!", set == result);
		try {
			result.add("abcd");
			fail("An UnsupportedOperationException expected!");
		} catch (UnsupportedOperationException e) {
			// ignore the expected exception
		}
		
		Set<String> result2 =
				LpAbstractStructureUnit.toUnmodifiableSet(result);
		assertTrue("The sets should be identical!", result == result2);
	}
}