/*
 * LpStructureUnitTestUtils.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-04): initial version
 * v0.2 (2007-01-04): normal form testing utilities added
 * v0.2.1 (2007-01-12):
 * - testNormalForm modified to expect IllegalArgumentException instead of
 *   NullPointerException
 * v0.2.2 (2007-01-18):
 * - testsNormalForm moved to LpPrettyPrinterTest (now called doTest())
 * - documentation updated
 * v1.0.0 (2007-05-05):
 * - promoted to version 1.0.0 :o)
 */

package lp.struct;

import junit.framework.*;

/**
 * Contains utility methods for testing common methods of classes in the package
 * {@link lp.struct}.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpStructureUnit
 */
public class LpStructureUnitTestUtils extends TestCase {
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	protected LpStructureUnitTestUtils(String testName) {
		super(testName);
	}
	
	/**
	 * Tests the {@link LpAbstractStructureUnit#toString()} method for
	 * {@code unit}.
	 *
	 * @param expected the expected result of {@code unit.toString()}.
	 * @param unit the tested {@link LpStructureUnit}
	 */
	protected void testToString(String expected, LpStructureUnit unit) {
		assertEquals("Output from " + unit.getClass().getSimpleName() +
				".toString() not as expected!", expected, unit.toString());
	}
}