/*
 * LpVariableTest.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-02): initial version
 * v0.2 (2007-01-02): testConstructorExceptions added
 * v0.2.1 (2007-01-04): testEqualsAndHashCode added
 * v0.2.2 (2007-01-04): testNormalFormAndToString added
 * v0.2.3 (2007-01-12):
 * - testConstructorExceptions modified to expect IllegalArgumentException
 *   instead of NullPointerException
 * v0.2.4 (2007-01-18):
 * - tests of normal form moved to LpPrettyPrinterTest
 * - testNormalFormAndToString renamed to testToString
 * - documentation updated
 * v1.0.0 (2007-05-05):
 * - promoted to version 1.0.0 :o)
 */

package lp.struct;

import junit.framework.*;

/**
 * Contains tests of the {@link LpVariable} class.
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpVariable
 */
public class LpVariableTest extends LpStructureUnitTestUtils {
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	public LpVariableTest(String testName) {
		super(testName);
	}
	
	/**
	 * Tests if the constructor throws the appropriate exceptions.
	 */
	public void testConstructorExceptions() {
		// variable's name must not be null
		try {
			new LpVariable(null);
			fail("A IllegalArgumentException expected!");
		} catch (IllegalArgumentException e) {
			// behaves as expected
		}
		
		// variable's name must not be empty
		try {
			new LpVariable("");
			fail("An IllegalArgumentException expected!");
		} catch (IllegalArgumentException e) {
			// behaves as expected
		}
	}
	
	/**
	 * Tests the {@link LpVariable#equals(Object)} and
	 * {@link LpVariable#hashCode()} methods.
	 */
	public void testEqualsAndHashCode() {
		LpVariable varRule1 = new LpVariable("Rule");
		LpVariable varRule2 = new LpVariable("Rule");
		
		LpVariable varAgent1 = new LpVariable("Agent");
		LpVariable varAgent2 = new LpVariable("Agent");
		
		testEqual(varRule1, varRule1);
		testEqual(varRule1, varRule2);
		testEqual(varRule2, varRule2);
		testEqual(varRule2, varRule1);
		
		testEqual(varAgent1, varAgent1);
		testEqual(varAgent1, varAgent2);
		testEqual(varAgent2, varAgent2);
		testEqual(varAgent2, varAgent1);
		
		testNotEqual(varRule1, null);
		testNotEqual(varAgent1, null);
		
		testNotEqual(varRule1, varAgent1);
		testNotEqual(varAgent1, varRule1);
	}
	
	/**
	 * Asserts that the given variables are equal and that their hash codes
	 * are equal.
	 *
	 * @param v1 first tested variable
	 * @param v2 second tested variable
	 */
	private void testEqual(LpVariable v1, LpVariable v2) {
		assertEquals("Variables '" + v1.toString() + "' and '" + v2.toString() +
				"' should be equal!", v1, v2);
		assertEquals("Equal variables should have equal hash codes!",
				v1.hashCode(), v2.hashCode());
	}
	
	/**
	 * Asserts that the given variables are not equal.
	 *
	 * @param v1 first tested variable
	 * @param v2 second tested variable
	 */
	private void testNotEqual(LpVariable v1, LpVariable v2) {
		assertFalse("Variables '" + v1 + "' and '" + v2 +
				"' should not be equal!", v1.equals(v2));
	}
	
	/**
	 * Tests the {@link LpVariable#toString()} method.
	 */
	public void testToString() {
		LpVariable v1 = new LpVariable("SomeVariable");
		testToString("SomeVariable", v1);
		
		LpVariable v2 = new LpVariable("A_different_variable");
		testToString("A_different_variable", v2);
	}
}