/*
 * LpPrinterTest.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-01-20): initial version
 * v0.2 (2007-01-27):
 * - test added
 * - docs added
 * v0.2.1 (2007-02-11):
 * - changed to reflect the new caching mechanism
 * v0.2.2 (2007-03-06):
 * - docs added
 * v1.0.0 (2007-05-05):
 * - changes that reflect the changes in LpPrettyPrinter
 */

package lp.struct.util;

import junit.framework.*;

/**
 * Contains tests of the non-abstract methods in the {@link LpPrinter} class. 
 *
 * @author Martin Slota
 * @version 1.0.0
 * @see LpPrinter
 */
public class LpPrinterTest extends TestCase {
	/**
	 * A default test case constructor.
	 *
	 * @param testName the name of the test case
	 */
	public LpPrinterTest(String testName) {
		super(testName);
	}
	
	/**
	 * Tests methods implemented in LpPrinter, i.e. appending a character 
	 * sequence, a character and a subsequence and resetting the sequence.
	 */
	public void test() {
		StringBuilder expContents = new StringBuilder();
		LpBuffer p = LpPrettyPrinter.getBuffer();
		
		expContents.append("blabla");
		p.append("blabla");
		assertEquals("Contents not as expected!",
				expContents.toString(), p.toString());
		
		expContents.append("cruel");
		p.append("hello cruel world", 6, 11);
		assertEquals("Contents not as expected!", 
				expContents.toString(), p.toString());
		
		expContents.append('x');
		p.append('x');
		assertEquals("Contents not as expected!", 
				expContents.toString(), p.toString());
		
		assertEquals("Length doesn't correspond to the contents' length!",
				12, p.length());
		assertEquals("A wrong character on the 11th position!",
				'l', p.charAt(10));
		assertEquals("A wrong subsequence!",
				"blacru", p.subSequence(3, 9));
		
		p.reset();
		assertEquals("Shouldn't contain any character after reset() was called!",
				"", p.toString());
		assertEquals("Length doesn't correspond to the contents' length!",
				0, p.length());
	}
}