/*
 * CollectingModelConsumer.java
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v1.0.0 (2007-05-06):
 * - extracted from LpSolverTest
 */

package lp.trans;

import java.util.HashSet;
import lp.unit.StableModel;


/**
 * A model consumer that collects all models it receives through the 
 * {@link #consume(StableModel)} method. Used in {@link LpSolverTest} and
 * {@link DlpSolverTest}.
 *
 * @author Martin Slota
 * @version 1.0.0
 */
class CollectingModelConsumer extends HashSet<StableModel>
		implements Consumer<StableModel> {
	/**
	 * No action needed here.
	 */	
	public void beforeConsuming() {
		// do nothing
	}

	/**
	 * No action needed here.
	 */	
	public void afterConsuming() {
		// do nothing
	}
	
	/**
	 * Adds {@code model} to this set.
	 * 
	 * @param model the model to be processed
	 */
	public void consume(StableModel model) {
		add(model);
	}
}