/*
 * EvolpVarTransformerTest.java
 * JUnit based test
 *
 * Copyright (C) 2006 - 2007 Martin Slota
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * History:
 * v0.1 (2007-04-25): initial version
 * v0.5 (2007-05-06):
 * - some documentation updated
 *
 * TODO finish docs
 * PENDING add more tests
 */

package lp.trans;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import lp.test.util.PartReader;
import lp.test.util.TabSeparatedReader;
import lp.unit.EvolpProgram;
import lp.unit.GeneralizedLogicProgram;
import lp.unit.LogicProgram;
import lp.unit.TransEvolpRuleType;

/**
 * Contains tests of the {@link EvolpVarTransformer} class.
 *
 * @author Martin Slota
 * @version 0.5
 * @see EvolpVarTransformer
 */
public class EvolpVarTransformerTest extends EvolpTransformerTest {
	private final EvolpVarTransformer evolpTrans;
	private final DlpTransformer dlpTrans;
	
	public EvolpVarTransformerTest(String testName) {
		super(testName);
		evolpTrans = new EvolpVarTransformer();
		dlpTrans = new DlpTransformer();
	}
	
	protected void doTest(String filename) throws IOException {
		Reader reader = new BufferedReader(
				new InputStreamReader(getClass().getResourceAsStream(
				filename)));
		Reader sourceReader = new PartReader(reader, '$');
		parser.setInput(sourceReader);
		EvolpProgram program = parser.parseEvolp();
		LogicProgram transformed = dlpTrans.transform(evolpTrans.transform(program));
		
		int eventCount = program.getEvents().size();
		LogicProgram expected = new GeneralizedLogicProgram();
		for (int group = 1; group <= eventCount; group++) {
			for (TransEvolpRuleType type : TransEvolpRuleType.values()) {
				parser.setInput(new PartReader(sourceReader, '$'));
				parser.parseAllRules(expected);
			}
		}
		
		assertEquals("The transformed program is not as expected!",
				expected, transformed);
		
		TabSeparatedReader tsr = new TabSeparatedReader(new PartReader(
				sourceReader, '$'));
		assertEquals("The transformed program is incomplete!",
				null, tsr.getNext());
		reader.close();
	}
}