#include <cstring>
#include <vector>
#include <iostream>
#include <fstream>
using namespace std;
#include "define.h"

#if !defined(COCO_PARSER_H__)
#define COCO_PARSER_H__



#include "Scanner.h"

#define T  true
#define x  false 



class Errors {
public:
	int count;			// number of errors detected

	Errors();
	void SynErr(int line, int col, int n);
	void SemErr(int line, int col, int n);
	void Error(int line, int col, char* s);
	void Exception(char* s);

}; // Errors

class Parser {
private:
	int _EOF;
	int _id;
	int _intConstant;
	int _charConstant;
	int _charStringConstant;
	int _doubleConstant;
	int _bracket;
	int _bracket2;
	int _anyType;
	int _anyCom;
	int _over;
	int maxT;

	Token *dummyToken;
	int errDist;
	int minErrDist;

	bool **set;
	
	void SynErr(int n);
	void Get();
	void Expect(int n);
	bool StartOf(int s);
	void ExpectWeak(int n, int follow);
	bool WeakSeparator(int n, int syFol, int repFol);

public:
	Scanner *scanner;
	Errors  *errors;

	Token *t;			// last recognized token
	Token *la;			// lookahead token

unsigned int parN;
unsigned int parNB;
unsigned int defN;
unsigned int tupN;
unsigned int lstN;
unsigned int quantN;
vector<unsigned int> * tupleN;
vector<unsigned int> * listN;
vector<string> * tab;
vector<ofstream *> * parF;
vector<string> * ext;
ofstream * inclFile;
ofstream * inclFile2;
bool defaultt;


bool isDef(string arg)
{

	vector<string>::size_type n = tab->size();
	bool b = true;

	for (vector<string>::size_type i = 0; i < n; i++)
	{

		string & st = tab->at(i);

		if(st.compare(arg) == 0)
		{

			cout << "ERROR - VARIABLE REDEFINITION" << endl;
			b = false;

		}

	}
	
	return b;

}


bool isFunCall()
{

	vector<string>::size_type n = tab->size();
	bool b = true;

	for (vector<string>::size_type i = 0; i < n; i++)
	{
	
	cout << "::::" << la->val << "::::" << endl;
	
		string & st = tab->at(i);

		if (st.compare(la->val) == 0)
		{
		
			b = false;
			
		}

	}
	
	return b;

}

bool iter()
{

	bool b = false;

	Token * tk = scanner->Peek();
	
	if (tk->kind == _id)
	{
	
		tk = scanner->Peek();
		
		if (tk->kind == _over)
		{
		
			b = true;
		
		}
	
	}
	
	scanner->ResetPeek();
	
	return b;

}

/*-----------------------------------------------------------------------*/





	Parser(Scanner *scanner);
	~Parser();
	void SemErr(char* msg);

	void Pcn();
	void ProgramDeclaration();
	void ProgramHeading(xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType);
	void MutableDeclarationList(unsigned int & type, string * & r, string * & rr, xxx_type2_1234567890 * & rrr, 
xxx_type2_1234567890 * & r4, xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType,
string * & post);
	void ProgramBody(bool & state, string * & r, string * & rr, xxx_type2_1234567890 * & rrr, xxx_type2_1234567890 * & r4, 
xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType);
	void MutableDeclaration(unsigned int & type, string * & r, string * & rr, xxx_type2_1234567890 * & rrr, 
xxx_type2_1234567890 * & r4, xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType, 
string * & post);
	void Expression(int & typ, string * & s, xxx_type_1234567890 * & var, bool & idOnly,
xxx_type_1234567890 * & rside, xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void SequentialComposition();
	void ParallelComposition(bool & b);
	void ChoiceComposition(bool & b);
	void Term(int & typ, string * & s, xxx_type_1234567890 * & var, bool & idOnly, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType, bool gatherMode);
	void Block(string * & r, string * & rr, xxx_type2_1234567890 * & rrr, xxx_type2_1234567890 * & r4, 
xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType,
xxx_type_1234567890 * & iterStackFile, xxx_type_1234567890 * & iterStackInclFile,
xxx_type_1234567890 * & iterStackInclFile2, bool & parComp, bool & isIter, string * iterHighConst);
	void Variable(string * & s, xxx_type_1234567890 * & var, bool & idOnly, string * & sd, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void AssignmentStatement(string * & str, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType, string * & expr, bool & ggg);
	void DefinitionStatement(string * & str, bool & bbbb, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType);
	void IterBoundary(string * & str, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType, string * & expr, bool & ggg);
	void Arguments(string * & s, xxx_type_1234567890 * var, xxx_type_1234567890 * & defvars, string * & pre, 
xxx_type_1234567890 * & defvarsType);
	void Index(string * & stl, xxx_type_1234567890 * & defvars, xxx_type_1234567890 * & defvarsType, xxx_type_1234567890 * & rside);
	void MultyplyingExpression(int & typ, string * & s, xxx_type_1234567890 * & var, bool & idOnly, 
xxx_type_1234567890 * & rside, xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void MoreTerms(int & typ, string * & s, xxx_type_1234567890 * & var, bool & idOnly, 
xxx_type_1234567890 * & rside, xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void PrimaryExpression(int & typ, string * & s, xxx_type_1234567890 * & var, bool & idOnly, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void MoreMultiply(int & typ, string * & s, xxx_type_1234567890 * & var, bool & idOnly, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void SignedNumber(int & typ, string * & s);
	void TupleConstructor(bool & tn, bool & st, string * & s, xxx_type_1234567890 * & var, bool & idOnly,
xxx_type_1234567890 * & rside, xxx_type_1234567890 * & defvars, string * & pre, 
xxx_type_1234567890 * & defvarsType, bool gatherMode);
	void ListConstructor(int & typ, bool & tn, bool & st, string * & s, xxx_type_1234567890 * & var, bool & idOnly,
xxx_type_1234567890 * & rside, xxx_type_1234567890 * & defvars, string * & pre, 
xxx_type_1234567890 * & defvarsType);
	void Elements(int & typ, bool & tn, bool & st, string * & s, xxx_type_1234567890 * & var, bool & idOnly, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);
	void Element(int & typ, bool & tn, bool & st, string * & s, xxx_type_1234567890 * & var, bool & idOnly, xxx_type_1234567890 * & rside, 
xxx_type_1234567890 * & defvars, string * & pre, xxx_type_1234567890 * & defvarsType);

	void Parse();

}; // end Parser



#endif // !defined(COCO_PARSER_H__)

